import { computed, ref, watch } from 'vue'
import { useSettings } from '@/components/composables/use-settings'
import { useUI } from '@/components/composables/use-ui'
import { RetrievalMode } from '@/models'
export function useRetrievalToggle() {
  const retrievalMode = computed(() => {
    return setup.value.retrievalMode || null
  })

  const { knowledgeBankSelection, dbSelection, retrieverSelected } = useSettings()
  const { setup } = useUI()

  const useRetriever = ref(retrieverSelected.value ? true : false)
  watch(retrieverSelected, (newValue) => {
    useRetriever.value = newValue ? true : false
  })

  const retriever = computed(() => {
    return setup.value.retriever
  })

  watch(useRetriever, () => {
    if (useRetriever.value && retriever.value) {
      dbSelection.value =
        setup.value.retrievalMode === RetrievalMode.DB ? retriever.value.name : null
      knowledgeBankSelection.value =
        setup.value.retrievalMode === RetrievalMode.KB ? retriever.value.id : null
      retrieverSelected.value = true
    } else {
      retrieverSelected.value = false
      dbSelection.value = null
      knowledgeBankSelection.value = null
    }
  })

  return {
    retrievalMode,
    useRetriever,
    retriever
  }
}
