import { createRouter, createWebHistory } from 'vue-router'
import { inIframe } from '@/common/utils'
import HomeView from '../routes/HomeView.vue'
import ConversationView from '../routes/ConversationView.vue'
import PageNotFound from '../views/PageNotFound.vue'
import EmptyStateView from '../routes/EmptyStateView.vue'

function getBase() {
  if (inIframe()) {
    const pathName = window.location.pathname
    if (pathName.includes('/dip/')) {
      // in iframe in dataiku
      return '/dip/api/webapps/view'
    } else {
      // in iframe not in dataiku
      return pathName
    }
  } else {
    // outside iframe
    let location = window.location.pathname.match(
      /(\/public-webapps\/[a-zA-Z0-9\-_]*\/[a-zA-Z0-9\-_]*).*/
    )
    if (location) {
      // as public-webapp
      return location[1]
    } else {
      // check as webapp
      location = window.location.pathname.match(/(\/webapps\/[a-zA-Z0-9\-_]*\/[a-zA-Z0-9\-_]*).*/)
    }
    // either webapp or no path
    return location ? location[1] : ''
  }
}

const router = createRouter({
  history: createWebHistory(getBase()),
  routes: [
    {
      path: '/',
      name: 'root',
      component: HomeView,
      redirect: '/new',
      children: [
        {
          path: '/conversation/:id',
          name: 'conversation-item',
          component: ConversationView,
          props: true
        },
        {
          path: 'new',
          name: 'new-conversation',
          component: EmptyStateView,
          props: () => {
            return { id: null }
          }
        },
        {
          path: 'new_with_media',
          name: 'new-media-conversation',
          component: EmptyStateView,
          props: () => {
            return { id: null, isMediaConv: true}
          }
        }
      ]
    },
    { path: '/:pathMatch(.*)*', name: 'notFound', component: PageNotFound }
  ]
})

export default router
