from enum import Enum
import os
from typing import Optional


class CheckFileName(Enum):
    OK = 1
    EMPTY = 2
    WITH_EXTENSION = 3


EXCEL_EXTENSION = [".xlsx", ".xls"]


def check_file_name(file_name: Optional[str]) -> CheckFileName:
    """
    Checks that a filename is not empty and does not already contain an Excel extension
    """
    if file_name is None:
        return CheckFileName.EMPTY

    maybe_extension = os.path.splitext(file_name)[1]
    if maybe_extension is not None and maybe_extension in EXCEL_EXTENSION:
        return CheckFileName.WITH_EXTENSION

    return CheckFileName.OK
