import logging

from dataiku import Folder

logger = logging.getLogger(__name__)
logging.basicConfig(
    level=logging.INFO, format="Excel Templater | %(levelname)s - %(message)s"
)


def do(payload, config, plugin_config, inputs):
    """
    Extracts the paths to template files located in the input folder
    """
    # The `input_folder` for template is defined first in `recipe.json` `inputRoles`, and should always be located at index 0
    if len(inputs) == 0 or "fullName" not in inputs[0]:
        return {"choices": []}

    input_folder_name = inputs[0]["fullName"]
    try:
        input_folder = Folder(input_folder_name)
    except Exception as e:
        logger.warning(f"Error while accessing input template folder: {e}")
        return {"choices": []}

    template_file_paths = input_folder.list_paths_in_partition()
    logger.info(f"Template file paths {template_file_paths}")

    choices = list(
        map(lambda path: {"value": path, "label": path}, template_file_paths)
    )

    return {"choices": choices}
