import dataiku
from dataiku.customrecipe import *
import pandas as pd
import os
import json
from feature_selection_ga import transform_df

#IO: load input dataset to be transformed
input_dataset_name = get_input_names_for_role('input_dataset')[0]
input_dataset = dataiku.Dataset(input_dataset_name)
df = input_dataset.get_dataframe()

#IO: load info json of selected features
input_folder_name = get_input_names_for_role('info_folder')[0]
input_folder_path = dataiku.Folder(input_folder_name).get_path()
with open(input_folder_path +"/output.json", "r") as read_json:
    input_info_json = json.load(read_json)
col_to_keep = input_info_json["selected_features"]


recipe_config = get_recipe_config()
target = recipe_config["target"]
df_train =  df.drop(target, axis=1)


df_res = transform_df(df_train, col_to_keep)

df_res = pd.concat([df_res, df[target]], axis=1)

output_dataset_name = get_output_names_for_role('output_dataset')[0]
output_dataset = dataiku.Dataset(output_dataset_name)
output_dataset.write_with_schema(df_res)