import numpy as np
from sklearn.model_selection import StratifiedKFold, KFold
from sklearn.metrics import f1_score, r2_score

class FitnessFunction:
    
    def __init__(self, task, n_splits = 5, *args, **kwargs):
        self.task = task
        self.n_splits = n_splits
    
    def compute_fitness(self, model, X, y):
        cv_set = np.repeat(-1., X.shape[0])
        
        if self.task=="classification":
            kf = StratifiedKFold(n_splits=self.n_splits)
        else:
            kf = KFold(n_splits=self.n_splits)
            
        for train_index,test_index in kf.split(X, y):
            X_train, X_test = X[train_index], X[test_index]
            y_train, y_test = y[train_index], y[test_index]
            model.fit(X_train, y_train)
            predicted_y = model.predict(X_test)
            cv_set[test_index] = predicted_y
            
        if self.task=="classification":
            return f1_score(y, cv_set)
        else:
            return r2_score(y, cv_set)