from flask import Blueprint, jsonify, request, send_file, current_app
from io import BytesIO

fetch_api = Blueprint("fetch_api", __name__, url_prefix="/api")

@fetch_api.errorhandler(Exception)
def handle_fetch_api_exception(e):
    current_app.logger.error(f"Error in fetch_api: {str(e)}")
    response = jsonify({"error": str(e)})
    response.status_code = 400
    return response

@fetch_api.route("/send_webapp_id", methods=["POST"])
def update_config():
    data_service = current_app.data_service
    result = data_service.update_config(request.get_json())
    return jsonify(result)
    
@fetch_api.route("/train_model", methods=["POST"])
def train_model():
    data_service = current_app.data_service
    result = data_service.train_model(request.get_json())
    return jsonify(result)

@fetch_api.route("/deploy_model", methods=["POST"])
def deploy_model():
    data_service = current_app.data_service
    result = data_service.deploy_model(request.get_json())
    return jsonify(result)

@fetch_api.route("/delete_model", methods=["POST"])
def delete_model():
    data_service = current_app.data_service
    result = data_service.delete_model(request.get_json())
    return jsonify(result)
    
@fetch_api.route("/get_latest_mltask_params", methods=["POST"])
def get_latest_mltask_params():
    data_service = current_app.data_service
    result = data_service.get_latest_mltask_params(request.get_json())
    return jsonify(result)

@fetch_api.route("/variables", methods=["POST"])
def get_variables():
    data_service = current_app.data_service
    result = data_service.get_variables(request.get_json())
    return jsonify(result)

@fetch_api.route("/models", methods=["POST"])
def get_models():
    data_service = current_app.data_service
    result = data_service.get_models(request.get_json())
    return jsonify(result)

@fetch_api.route("/predicted_base", methods=["POST"])
def get_predicted_base():
    data_service = current_app.data_service
    result = data_service.get_predicted_base(request.get_json())
    return jsonify(result)

@fetch_api.route("/base_values", methods=["POST"])
def get_base_values():
    data_service = current_app.data_service
    result = data_service.get_base_values(request.get_json())
    return jsonify(result)

@fetch_api.route("/lift_data", methods=["POST"])
def get_lift_data():
    data_service = current_app.data_service
    result = data_service.get_lift_data(request.get_json())
    return jsonify(result)

@fetch_api.route("/relativities", methods=["POST"])
def get_relativities():
    data_service = current_app.data_service
    result = data_service.get_relativities(request.get_json())
    return jsonify(result)

@fetch_api.route("/get_variable_level_stats", methods=["POST"])
def get_variable_level_stats():
    data_service = current_app.data_service
    result = data_service.get_variable_level_stats(request.get_json())
    return jsonify(result)
    
@fetch_api.route("/get_model_metrics", methods=["POST"])
def get_model_metrics():
    data_service = current_app.data_service
    result = data_service.get_model_metrics(request.get_json())
    return jsonify(result)

@fetch_api.route('/export_model', methods=['POST'])
def export_model():
    data_service = current_app.data_service
    csv_data = data_service.export_model(request.get_json())
    csv_io = BytesIO(csv_data)
    # Serve the CSV file for download
    return send_file(
        csv_io,
        mimetype='text/csv',
        as_attachment=True,
        download_name='model.csv'
    )

@fetch_api.route('/export_variable_level_stats', methods=['POST'])
def export_variable_level_stats():
    data_service = current_app.data_service
    csv_data = data_service.export_variable_level_stats(request.get_json())
    csv_io = BytesIO(csv_data)
    # Serve the CSV file for download
    return send_file(
        csv_io,
        mimetype='text/csv',
        as_attachment=True,
        download_name='variable_level_stats.csv'
    )

@fetch_api.route('/export_lift_chart', methods=['POST'])
def export_lift_chart():
    data_service = current_app.data_service
    csv_data = data_service.export_lift_chart(request.get_json())
    csv_io = BytesIO(csv_data)
    # Serve the CSV file for download
    return send_file(
        csv_io,
        mimetype='text/csv',
        as_attachment=True,
        download_name='lift_chart.csv'
    )

@fetch_api.route('/export_one_way', methods=['POST'])
def export_one_way():
    data_service = current_app.data_service
    csv_data = data_service.export_one_way(request.get_json())
    csv_io = BytesIO(csv_data)
    # Serve the CSV file for download
    return send_file(
        csv_io,
        mimetype='text/csv',
        as_attachment=True,
        download_name='one_way_variable.csv'
    )
@fetch_api.route("/get_dataset_columns", methods=["POST"])
def get_dataset_columns():
    data_service = current_app.data_service
    result = data_service.get_dataset_columns(request.get_json())
    return jsonify(result)

@fetch_api.route("/get_project", methods=["GET"])
def get_project():
    data_service = current_app.data_service
    result = data_service.get_project()
    return jsonify(result)

@fetch_api.route("/get_ml_tasks", methods=["GET"])
def get_ml_tasks():
    data_service = current_app.data_service
    result = data_service.get_ml_tasks()
    return jsonify(result)

@fetch_api.route("/get_datasets", methods=["GET"])
def get_datasets():
    data_service = current_app.data_service
    result = data_service.get_datasets()
    return jsonify(result)

@fetch_api.route("/get_variables_for_dataset", methods=["POST"])
def get_variables_for_dataset():
    data_service = current_app.data_service
    result = data_service.get_variables_for_dataset(request.get_json())
    return jsonify(result)

@fetch_api.route("/create_ml_task", methods=["POST"])
def create_ml_task():
    data_service = current_app.data_service
    result = data_service.create_ml_task(request.get_json())
    return jsonify(result)