/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.geozip;

import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.geozip.ZipGeoDataUtils;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ZipCodeGeocoder
extends SingleRowProcessor
implements Processor,
ProcessorWithResourceFiles {
    public static final ProcessorMeta<ZipCodeGeocoder, Parameter> META = new ProcessorMeta<ZipCodeGeocoder, Parameter>(){

        public String getName() {
            return "ZipCodeGeocoder";
        }

        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.GEOGRAPHIC, ProcessorTag.ENRICH});
        }

        public String getHelp() {
            return "This processor performs geocoding of zip codes (country + zip code -> lat/lon)\n# Input\n\n* Country column: Column with country identifier (name, ISO code or FIPS code). **Caution, country names correspond to the names associated with iso-codes in ISO-3166, e.g, use 'Guadeloupe' (instead of 'France') to locate a place in Guadeloupe ([list of country <-> isocode](https://www.geonames.org/countries/)).**\n* Zipcode column: Column with the zipcode you want to geocode.\n\n# Output\n\nThe output is one column with a geopoint corresponding to the best match for the zip code. If no match is found, the processor outputs nothing.\n\nThis processor contains about **5 millions known zipcodes** and supports about **100 countries** ([see here](https://download.geonames.org/export/zip/)).\n\nExtended zipcodes for Canada, Netherlands and United Kingdom are not supported: full zipcodes are mapped with their shortest version (e.g, 'B10 0AB' -> 'B10').";
        }

        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        public ProcessorDesc describe() {
            return ProcessorDesc.withGenericForm((String)this.getName(), (String)"Zipcode geocoding").withMNEColParam("countryCol", "Input country column").withMNEColParam("zipCodeCol", "Input zipcode column").withMNEColParam("outputCol", "Output column");
        }

        public ZipCodeGeocoder build(Parameter parameter) throws Exception {
            return new ZipCodeGeocoder(parameter);
        }
    };
    final Parameter parameter;
    private Column countryCD;
    private Column zipCD;
    private Column outCD;
    private static ZipGeoDataUtils.ZipGeoData cache;
    private static final Logger logger;
    public File zipResourceFolder;
    private File countriesResourceFolder = new File(System.getenv("DKUINSTALLDIR"), "resources/publicdata/countries/countries.csv.gz");

    public ZipCodeGeocoder(Parameter parameter) {
        this.parameter = parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCache(File countriesResourceFolder, File zipResourceFolder) throws Exception {
        Class<ZipCodeGeocoder> clazz = ZipCodeGeocoder.class;
        synchronized (ZipCodeGeocoder.class) {
            if (cache == null) {
                cache = ZipGeoDataUtils.getData(countriesResourceFolder, zipResourceFolder);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void init() throws Exception {
        ZipCodeGeocoder.initCache(this.countriesResourceFolder, this.zipResourceFolder);
        this.countryCD = this.cf.column(this.parameter.countryCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.zipCD = this.cf.column(this.parameter.zipCodeCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.outCD = this.cf.columnAfter(this.parameter.zipCodeCol, this.parameter.outputCol, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String country = row.get(this.countryCD);
        String zip = row.get(this.zipCD);
        if (StringUtils.isBlank((String)country) || StringUtils.isBlank((String)zip)) {
            return;
        }
        GenericRecord record = cache.lookup(country, zip);
        if (record == null) {
            return;
        }
        String point = "POINT (" + record.get("lon") + " " + record.get("lat") + ")";
        row.put(this.outCD, point);
    }

    public void postProcess() {
    }

    public Map<String, File> gatherRequirements() {
        HashMap<String, File> ret = new HashMap<String, File>();
        IPluginsRegistryService ps = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        ret.put("dku.zipcodegeocoder.resource", ps.getPluginResourceFolder("geozip"));
        ret.put("dku.zipcodegeocoder.countryresource", this.countriesResourceFolder);
        return ret;
    }

    public void setRequiredFiles(Map<String, File> requiredFiles) {
        this.zipResourceFolder = requiredFiles.get("dku.zipcodegeocoder.resource");
        this.countriesResourceFolder = requiredFiles.get("dku.zipcodegeocoder.countryresource");
    }

    static {
        logger = Logger.getLogger((String)"dku.shaker.geo");
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String countryCol;
        String zipCodeCol;
        String outputCol;

        public void validate() throws IllegalArgumentException {
        }
    }
}

