/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.geozip;

import com.dataiku.dip.data.geo.CountriesGeoDataLoader;
import com.dataiku.dip.input.formats.csv.NoEscapeNoQuoteCSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ZipGeoDataUtils {
    private static final Set<String> exceptionWords = Stream.of("and", "or", "of", "the").collect(Collectors.toSet());
    private static final Logger logger = Logger.getLogger((String)"dku.shaker.geo");

    public static Schema getAvroSchema() {
        return (Schema)SchemaBuilder.record((String)"geozipcode").fields().name("isoCode").type().stringType().stringDefault("").name("zipCode").type().stringType().noDefault().name("lat").type().doubleType().noDefault().name("lon").type().doubleType().noDefault().endRecord();
    }

    public static ZipGeoData getData(File countryResourceFolder, File zipResourceFolder) throws Exception {
        ZipGeoData ret = new ZipGeoData();
        ret.countries = CountriesGeoDataLoader.load((File)countryResourceFolder);
        File avroFile = new File(zipResourceFolder, "zipcodes.avro");
        GenericDatumReader datumReader = new GenericDatumReader(ZipGeoDataUtils.getAvroSchema());
        DataFileReader dataFileReader = new DataFileReader(avroFile, (DatumReader)datumReader);
        while (dataFileReader.hasNext()) {
            GenericRecord record = (GenericRecord)dataFileReader.next();
            String lookup = record.get("isoCode") + "_" + record.get("zipCode");
            ret.zipData.put(lookup, record);
        }
        dataFileReader.close();
        return ret;
    }

    public static void main(String[] args) throws Exception {
        File resourceFolder = new File("./resource");
        File avroFile = new File(resourceFolder, "zipcodes.avro");
        Schema avroSchema = ZipGeoDataUtils.getAvroSchema();
        GenericDatumWriter datumWriter = new GenericDatumWriter(avroSchema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.setCodec(CodecFactory.snappyCodec());
        dataFileWriter.create(avroSchema, avroFile);
        logger.info((Object)"Load geonames data");
        NoEscapeNoQuoteCSVParser parser = new NoEscapeNoQuoteCSVParser((LineReader)new InputStreamLineReader((InputStream)new GZIPInputStream(new FileInputStream(new File(resourceFolder, "geonames-zipcodes.csv.gz"))), "utf8"), '\t');
        ArrayList out = new ArrayList();
        parser.next(out);
        int done = 0;
        while (parser.next(out)) {
            if (StringUtils.isBlank((String)((String)out.get(10)))) continue;
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put("isoCode", out.get(0));
            record.put("zipCode", out.get(1));
            record.put("lon", (Object)Double.parseDouble((String)out.get(10)));
            record.put("lat", (Object)Double.parseDouble((String)out.get(9)));
            dataFileWriter.append((Object)record);
            if (++done % 1000 != 0) continue;
            logger.info((Object)("DONE " + done + " zip codes"));
        }
        dataFileWriter.close();
    }

    public static class ZipGeoData {
        CountriesGeoDataLoader.CountryGeoData countries;
        public Map<String, GenericRecord> zipData = new HashMap<String, GenericRecord>();

        public GenericRecord lookup(String country, String zipCode) {
            String sanitizedCountry = this.sanitizeCountryName(country);
            String iso2 = this.countries.getISO2Code(sanitizedCountry);
            if (iso2 == null) {
                return null;
            }
            String entry = iso2 + "_" + this.normalizeZipCode(iso2, zipCode);
            return this.zipData.get(entry);
        }

        private String sanitizeCountryName(String country) {
            CharSequence[] splittedString = country.split(" ");
            for (int i = 0; i < splittedString.length; ++i) {
                if (exceptionWords.contains(splittedString[i])) continue;
                splittedString[i] = ((String)splittedString[i]).substring(0, 1).toUpperCase() + ((String)splittedString[i]).substring(1);
            }
            return String.join((CharSequence)" ", splittedString);
        }

        private String normalizeZipCode(String iso2, String zipCode) {
            if ("LU".equals(iso2) && !zipCode.startsWith("L-")) {
                return "L-" + zipCode;
            }
            if ("FR".equals(iso2) && zipCode.length() == 4) {
                return "0" + zipCode;
            }
            zipCode = this.truncateZipCode(iso2, zipCode);
            return zipCode;
        }

        private String truncateZipCode(String iso2, String zipCode) {
            if ("CA".equals(iso2) || "GB".equals(iso2) || "NL".equals(iso2) || "IE".equals(iso2)) {
                zipCode = zipCode.split(" ")[0];
            }
            return zipCode;
        }
    }
}

