/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.iprangematcher;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class IPRangeMatcher
extends FilterAndFlagProcessor
implements Processor {
    static final Pattern RANGE_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})[-_\\t ]{1,3}(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    static final Pattern CIDR_PATTERN = Pattern.compile("(\\d{1,3})(?:.(\\d{1,3})(?:.(\\d{1,3})(?:.(\\d{1,3}))?)?)?\\/(\\d{1,2})");
    static final Pattern IP_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private final Parameter parameter;
    private ArrayList<Range> rangeList;
    public static final ProcessorMeta<IPRangeMatcher, Parameter> META_FLAG = new ProcessorMeta<IPRangeMatcher, Parameter>(){

        public String getName() {
            return "FlagOnIPRange";
        }

        public String getDocPage() {
            return "flag-on-ip-range";
        }

        public Category getCategory() {
            return Category.FILTER;
        }

        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER, ProcessorTag.CLEANSING});
        }

        public String getHelp() {
            return "This processor flags rows with IPs that belong to specified network ranges.\n\nYou can specify the network ranges with:\n\n* Normal ranges: 'IP - IP' (eg 192.168.0.1 - 192.168.0.99)\n* CIDR ranges: eg 64.0.0.0/2 or 64/2\n";
        }

        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        public ProcessorDesc describe() {
            return ProcessorDesc.withGenericForm((String)this.getName(), (String)(1.actionVerb((String)"Flag") + " rows if IPs are within specified ranges")).withParam("ranges", "textarea", true, false, "Ranges (IP or CIDR)").withFilterAndFlagMode("FLAG");
        }

        public IPRangeMatcher build(Parameter parameter) {
            return new IPRangeMatcher(parameter);
        }
    };
    public static final ProcessorMeta<IPRangeMatcher, Parameter> META_FILTER = new ProcessorMeta<IPRangeMatcher, Parameter>(){

        public String getName() {
            return "FilterOnIPRange";
        }

        public String getDocPage() {
            return "filter-on-ip-range";
        }

        public Category getCategory() {
            return Category.FILTER;
        }

        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER, ProcessorTag.CLEANSING});
        }

        public String getHelp() {
            return "This processor flags rows with IPs that belong to specified network ranges.\n\nYou can specify the network ranges with:\n\n* Normal ranges: 'IP - IP' (eg 192.168.0.1 - 192.168.0.99)\n* CIDR ranges: eg 64.0.0.0/2 or 64/2\n# Action\n\nYou can select the action to perform on matching (in range) rows:\n\n* Remove matching rows\n* Keep matching rows only\n* Clear the content of the matching cells\n* Clear the content of the non-matching cells\n\n# Columns selection\n\n";
        }

        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        public ProcessorDesc describe() {
            return ProcessorDesc.withGenericForm((String)this.getName(), (String)(2.actionVerb((String)"Filter") + " rows/cells if IPs are within specified ranges")).withParam("ranges", "textarea", true, false, "Ranges (IP or CIDR)").withFilterAndFlagMode("FILTER");
        }

        public IPRangeMatcher build(Parameter parameter) {
            return new IPRangeMatcher(parameter);
        }
    };

    public IPRangeMatcher(Parameter parameter) {
        this.parameter = parameter;
    }

    public FilterAndFlagProcessor.FilterAndFlagParams getParams() {
        return this.parameter;
    }

    public void init() throws Exception {
        super.init();
        String ranges = this.parameter.ranges;
        this.rangeList = new ArrayList();
        if (StringUtils.isBlank((String)this.parameter.ranges)) {
            throw new IllegalArgumentException("Should input at least one range!");
        }
        try (Scanner scanner = new Scanner(ranges);){
            Matcher rangeMatcher = RANGE_PATTERN.matcher("");
            Matcher cidrMatcher = CIDR_PATTERN.matcher("");
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                rangeMatcher.reset(line);
                cidrMatcher.reset(line);
                if (rangeMatcher.find()) {
                    long rangeStart = IPRangeMatcher.ipToLong(rangeMatcher.group(1), rangeMatcher.group(2), rangeMatcher.group(3), rangeMatcher.group(4));
                    long rangeEnd = IPRangeMatcher.ipToLong(rangeMatcher.group(5), rangeMatcher.group(6), rangeMatcher.group(7), rangeMatcher.group(8));
                    this.rangeList.add(new Range(rangeStart, rangeEnd, line));
                    continue;
                }
                if (!cidrMatcher.find()) continue;
                long addr = IPRangeMatcher.ipToLong(cidrMatcher.group(1), cidrMatcher.group(2), cidrMatcher.group(3), cidrMatcher.group(4));
                int mask = -1 << 32 - Integer.parseInt(cidrMatcher.group(5));
                long rangeStart = addr & (long)mask;
                long rangeEnd = rangeStart + (long)(~mask);
                this.rangeList.add(new Range(rangeStart, rangeEnd, line));
            }
        }
        if (this.rangeList.isEmpty()) {
            throw new IllegalArgumentException("Specified range bounds could not be parsed.");
        }
        Collections.sort(this.rangeList, new Comparator<Range>(){

            @Override
            public int compare(Range r1, Range r2) {
                if (r1.start == r2.start) {
                    return Long.compare(r1.end, r2.end);
                }
                return Long.compare(r1.start, r2.start);
            }
        });
    }

    private static int parseOctet(String octet) {
        int result = Integer.parseInt(octet);
        if (result >= 0 && result <= 255) {
            return result;
        }
        return 0;
    }

    static long ipToLong(String a, String b, String c, String d) {
        return IPRangeMatcher.ipToLong(IPRangeMatcher.parseOctet(a), b == null ? 0L : (long)IPRangeMatcher.parseOctet(b), c == null ? 0L : (long)IPRangeMatcher.parseOctet(c), d == null ? 0L : (long)IPRangeMatcher.parseOctet(d));
    }

    private static long ipToLong(long a, long b, long c, long d) {
        return a << 24 & 0xFFFFFFFFFF000000L | b << 16 & 0xFF0000L | c << 8 & 0xFF00L | d & 0xFFL;
    }

    public boolean matchCell(Row row, Column column) throws Exception {
        Matcher ipMatcher;
        String currentIP = row.get(column);
        if (!StringUtils.isBlank((String)currentIP) && (ipMatcher = IP_PATTERN.matcher(currentIP)).find()) {
            long addr = IPRangeMatcher.ipToLong(ipMatcher.group(1), ipMatcher.group(2), ipMatcher.group(3), ipMatcher.group(4));
            for (Range r : this.rangeList) {
                if (r.start <= addr && addr <= r.end) {
                    return true;
                }
                if (r.start <= addr) continue;
                return false;
            }
        }
        return false;
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    extends FilterAndFlagProcessor.FilterAndFlagParams
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String ranges;

        public void validate() throws IllegalArgumentException {
        }
    }

    private static class Range {
        final long start;
        final long end;
        final String representation;

        Range(long start, long end, String representation) {
            this.start = start;
            this.end = end;
            this.representation = representation;
        }

        public String toString() {
            return String.format("[%d %d : '%s']", this.start, this.end, this.representation);
        }
    }
}

