package com.customllm.llm;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GPTAIChatChunkResponseAdapter {
   private GPTAIChatChunkResponseAdapter() {
   }

   @SuppressWarnings("unchecked")
   public static LLMClient.StreamedCompletionResponseChunk adapt(GptApiImplementation.OpenAIChatChunkResponse response) {
      if (response.choices != null && !response.choices.isEmpty()) {
         
         GptApiImplementation.Choice choice = (GptApiImplementation.Choice)response.choices.get(0);
         LLMClient.StreamedCompletionResponseChunk resp = new LLMClient.StreamedCompletionResponseChunk();
         resp.text = choice.delta.content;


         if (choice.delta.toolCalls != null && !choice.delta.toolCalls.isEmpty()) {
            resp.toolCalls = (List)choice.delta.toolCalls.stream().map(GPTAIChatChunkResponseAdapter::adapt).collect(Collectors.toList());
         }

         return resp;
      } else {
         throw new IllegalArgumentException("Empty chat chunk response");
      }
   }

   @Nullable
   public static String getRefusal(GptApiImplementation.OpenAIChatChunkResponse response) {
      if (response.choices != null && !response.choices.isEmpty()) {
         GptApiImplementation.Choice choice = (GptApiImplementation.Choice)response.choices.get(0);
         return choice.delta.refusal;
      } else {
         return null;
      }
   }

   private static LLMClient.AbstractToolCall adapt(GptApiImplementation.PartToolCall tc) {
      LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
      function.name = tc.function.name;
      function.arguments = tc.function.arguments;
      LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
      ftc.index = tc.index;
      ftc.id = tc.id;
      ftc.function = function;
      return ftc;
   }

   @Nullable
   public static LLMClient.FinishReason extractFinishReason(GptApiImplementation.OpenAIChatChunkResponse response) {
      if (response.choices != null && !response.choices.isEmpty()) {
         GptApiImplementation.Choice choice = (GptApiImplementation.Choice)response.choices.get(0);
         return choice.finishReason == null ? null : FinishReasonResponseAdapter.adapt(choice.finishReason);
      } else {
         return null;
      }
   }
}
