# Dataiku OSM Enrichment Plugin

Current Version: 1.0.0

## Overview

This plugin provides the ability to retrieve a list of given "Points of Interests" (POI) from OpenStreetMap. It also creates an aggregated heatmap based on the categories of the POI. The plugin is based on the [overpass api](https://wiki.openstreetmap.org/wiki/Overpass_API).

## Usage

### Parameters

* You firts need to set the bounding box of the POI you want to retrieve (min_latitude,min_longitude,min_latitude,max_latitude).

* Then you need to specify the "grid_size". We will take the box you just defined and devide the width and the height grid_size times, which means you will get grid_size*grid_size rectangles to aggregate the POI.

* You can optionally decide to sepcify additional tags (ie POI) to retrieve. You can take a look at the available tags [here](https://taginfo.openstreetmap.org/keys). The default list for this plugin is shop,leisure,sport,tourism,historic,amenity,railway.

### Input

There is no input needed for this plugin

### Outputs

* List of POI: This dataset will contains the list of the retrieved POI. 
The schema will be "id, lat, lon, tags".

* Aggregated heatmap: This dataset contains one raw per rectangle in the grid, with the aggregated info per categories. 
The schema will be "lat_square_center, lon_square_center, id_square, category_entertainment, category_food, category_public_service, category_shop, category_supermarket, category_transport geom, geom".

The "geom" field gives you the ability to directly draw the heatmap with the visual "geometry map" of Dataiku DSS.

## Limitation

* Even if you specify additional tags in the advanced option, they will not be used in the heatmap because the possible values associated to the tags are very diverse and they need to be processed to classify them into some categories (food, public_service ...).

* You may have to refresh your browser the first time you create a recipe with this plugin (if the map doesnt'appear)

### Licence

Copyright 2020-2021 Dataiku SAS

This plugin is distributed under the Apache License version 2.0