# -*- coding: utf-8 -*-
import pandas as pd
from dataiku.customrecipe import *
from osm_enrichment_deprecated.enrichment import enrich_bounding_box, make_grid, aggregate_by_category_on_grid
import dataiku


# Read params
cfg = get_recipe_config();
print(cfg)
grid_size = int(cfg.get('gridSize', 0))

bbox = {
    "minLat": float(cfg['minLat']),
    "minLon": float(cfg['minLon']),
    "maxLat": float(cfg['maxLat']),
    "maxLon": float(cfg['maxLon'])
}

tags = cfg.get('tags', "").split(',')
default_tags = [
    'shop',
    'leisure',
    'sport',
    'tourism',
    'historic',
    'amenity',
    'railway'
]
tags = tags + default_tags

# Get outputs

output_A_names = get_output_names_for_role('pois')
if len(output_A_names) > 0:
    pois_dataset = dataiku.Dataset(output_A_names[0])
else:
    pois_dataset = None

output_B_names = get_output_names_for_role('aggregations')
if len(output_B_names) > 0:
    aggregations_dataset = dataiku.Dataset(output_B_names[0])
else:
    aggregations_dataset = None

# Run

data = enrich_bounding_box(bbox, tags)
pois = pd.DataFrame(data['elements'])
pois['lat']=pois[['center','lat','type']].apply(lambda x: x[1] if x[2]=='node' else x[0]['lat'],axis=1)
pois['lon']=pois[['center','lon','type']].apply(lambda x: x[1] if x[2]=='node' else x[0]['lon'],axis=1)
grid = make_grid(bbox, grid_size, grid_size)
aggregated_df = aggregate_by_category_on_grid(data, grid)

# Write ouputs

if pois_dataset is not None:
    pois_dataset.write_with_schema(pois[['id', 'lat', 'lon', 'tags']])
if aggregations_dataset is not None:
    aggregations_dataset.write_with_schema(aggregated_df)