/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.formats.qvx;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.io.BinaryStreamEncoder;
import com.dataiku.dip.plugin.CustomFormatOutput;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.formats.qvx.QvxHeaderWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QvxFormatOutput
implements CustomFormatOutput {
    private List<SchemaColumn> schemaColumns;
    private List<Column> columns = new ArrayList<Column>();
    private WarningsContext wc;
    private OutputStream os;
    private BinaryStreamEncoder bse;
    private static final Logger logger = Logger.getLogger((String)"dssplugin.qvx.output");

    public void header(ColumnFactory cf, OutputStream os) throws Exception {
        this.os = os;
        this.bse = new BinaryStreamEncoder(os);
        for (SchemaColumn sc : this.schemaColumns) {
            this.columns.add(cf.column(sc.getName()));
        }
        QvxHeaderWriter writer = new QvxHeaderWriter(os);
        writer.setSchema(this.schemaColumns);
        writer.write();
    }

    public void format(Row row, ColumnFactory cf, OutputStream os) throws Exception {
        assert (this.os == os);
        try {
            for (int i = 0; i < this.columns.size(); ++i) {
                Column columnHandle = this.columns.get(i);
                String rawCellValue = row.get(columnHandle);
                this.writeNullable(rawCellValue, this.schemaColumns.get(i));
            }
        }
        catch (Exception e) {
            this.wc.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_TYPE, "Bad data " + e.getMessage(), logger);
        }
    }

    private void writeNullable(String rawCellValue, SchemaColumn schemaColumn) throws IOException {
        boolean isNull;
        boolean bl = isNull = rawCellValue == null;
        if (!isNull && rawCellValue instanceof String && schemaColumn.getType() != Type.STRING) {
            isNull = StringUtils.isBlank((String)rawCellValue);
            if ("null".equals(rawCellValue) && (schemaColumn.getType() == Type.ARRAY || schemaColumn.getType() == Type.MAP)) {
                isNull = true;
            }
        }
        if (isNull) {
            this.os.write(1);
        } else {
            assert (rawCellValue != null);
            switch (schemaColumn.getType()) {
                case BOOLEAN: {
                    this.os.write(0);
                    boolean booleanVal = "true".equals(rawCellValue) || "True".equals(rawCellValue) || "TRUE".equals(rawCellValue);
                    byte byteVal = (byte)(booleanVal ? 1 : 0);
                    this.os.write(byteVal);
                    break;
                }
                case TINYINT: {
                    this.os.write(0);
                    this.os.write(Byte.parseByte(rawCellValue));
                    break;
                }
                case SMALLINT: {
                    this.os.write(0);
                    this.bse.writeLE16(Short.parseShort(rawCellValue));
                    break;
                }
                case INT: {
                    this.os.write(0);
                    this.bse.writeLE32(Integer.parseInt(rawCellValue));
                    break;
                }
                case BIGINT: {
                    this.os.write(0);
                    this.bse.writeLE64(Long.parseLong(rawCellValue));
                    break;
                }
                case FLOAT: {
                    this.os.write(0);
                    this.bse.writeFloat(Float.parseFloat(rawCellValue));
                    break;
                }
                case DOUBLE: {
                    this.os.write(0);
                    this.bse.writeDouble(Double.parseDouble(rawCellValue));
                    break;
                }
                case STRING: 
                case DATE: 
                case ARRAY: 
                case MAP: 
                case OBJECT: 
                case GEOMETRY: 
                case GEOPOINT: {
                    this.os.write(0);
                    this.os.write(rawCellValue.getBytes("UTF-8"));
                    this.os.write(0);
                }
            }
        }
    }

    public void footer(ColumnFactory cf, OutputStream os) throws Exception {
    }

    public void cancel(OutputStream os) throws Exception {
    }

    public void setOutputSchema(Schema schema) {
        this.schemaColumns = schema.getColumns();
    }

    public void setWarningsContext(WarningsContext warningsContext) {
        this.wc = warningsContext;
    }

    public void close() throws Exception {
        this.bse.close();
    }
}

