# General description

This project is a template to build a complete recommendation workflow using both DSS visual recipes and the recommendation system plugin.

It accepts as input a dataset of dated interactions between users and items (with users, items and timestamp columns). 
The system will base its recommendations on implicit feedbacks (no ratings are used).

Once the recommendation model is trained, an additional dataset of users (with a users column) can be provided and a dataset of the top items to recommend to each user will be built. 

The input datasets must be stored in a PostgreSQL or Snowflake connection and all computation will be done in the selected connection.

# Goal

This application can be used as a template to start building a complete recomendation workflow in SQL. Once the flow is instantiated through the application, it becomes easier to customize it by adding more features, algorithms and affinity scores.

The complete flow can be integrated into a production project that evaluates the recommendations.

# Workflow overview

To see the full description, go on [Detailed workflow](article:9)

The recommendation workflow works as follows:
 - Input data is split based on time into 2 datasets:
   - One to compute affinity scores between users and items
   - One to train a ML model
 - Affinity scores between users and items are computed
 - Positive and negative samples with affinity scores are generated
 - These samples are used to train a ML model that uses affinity scores as features
 - Affinity scores are recomputed on all input data this time 
 - User-item pairs are scored on the ML model
 - These scores are used to recommend the top items per user
