/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.formats.spss;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.plugin.CustomFormat;
import com.dataiku.dip.plugin.CustomFormatInput;
import com.dataiku.dip.plugin.CustomFormatOutput;
import com.dataiku.dip.plugin.CustomFormatSchemaDetector;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.formats.spss.SPSSStreamReader;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;

public class SPSSFormat
implements CustomFormat {
    public CustomFormatInput getReader(JsonObject config, JsonObject pluginConfig) {
        boolean useVarLabels = false;
        boolean useValueLabels = false;
        if (config != null) {
            JsonElement tmpElt = config.get("use_varlabels");
            if (tmpElt != null && tmpElt.isJsonPrimitive()) {
                useVarLabels = tmpElt.getAsBoolean();
            }
            if ((tmpElt = config.get("use_valuelabels")) != null && tmpElt.isJsonPrimitive()) {
                useValueLabels = tmpElt.getAsBoolean();
            }
        }
        return new SPSSFormatInput(useVarLabels, useValueLabels);
    }

    public CustomFormatOutput getWriter(JsonObject config, JsonObject pluginConfig) {
        throw new UnsupportedOperationException("No output for this format.");
    }

    public CustomFormatSchemaDetector getDetector(JsonObject config, JsonObject pluginConfig) {
        throw new UnsupportedOperationException("No detector for this format.");
    }

    public static class SPSSFormatInput
    implements CustomFormatInput {
        private WarningsContext wc;
        private boolean useVarLabels;
        private boolean useValueLabels;

        SPSSFormatInput(boolean useVarLabels, boolean useValueLabels) {
            this.useVarLabels = useVarLabels;
            this.useValueLabels = useValueLabels;
        }

        public void setSchema(Schema schema, boolean allowExtraColumns) {
        }

        public void setWarningsContext(WarningsContext warnContext) {
            this.wc = warnContext;
        }

        public void run(InputStreamWithContextInfo in, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
            SPSSStreamReader reader = new SPSSStreamReader(in.getInputStream(), cf, this.wc, this.useVarLabels, this.useValueLabels);
            reader.readData(out, rf);
        }

        public void close() throws IOException {
        }
    }
}

