/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.formats.spss;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.formats.spss.SPSSFormat;
import com.dataiku.dss.formats.spss.SPSSInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SPSSStreamReader {
    private static final Logger logger = Logger.getLogger(SPSSFormat.class);
    private static final String START_TOKEN = "$FL2";
    private static final Long GREGORIAN_CALENDAR_OFFSET = 12219379200000L;
    private static final Double MISSING_VALUE = -1.7976931348623157E308;
    private static final Map<Integer, SimpleDateFormat> dateTypeToFormat;
    private ArrayList<VariableRecord> vars = new ArrayList();
    private Map<Integer, Map<List<Byte>, String>> valueLabelRecords = new HashMap<Integer, Map<List<Byte>, String>>();
    private Meta meta;
    private LongVariableNames longVariableNames;
    private VeryLongStrings veryLongStrings;
    private final SPSSInputStream is;
    private final ColumnFactory cf;
    private final WarningsContext wc;
    private final boolean useVarLabels;
    private final boolean useValueLabels;
    private boolean headerParsed;
    private int flagCursor = -1;
    private byte[] flagsBuffer = new byte[8];
    private static final int SKIP = 0;
    private static final int EOF = 252;
    private static final int NOT_COMPRESSED = 253;
    private static final int BLANK = 254;
    private static final int MISSING = 255;

    public SPSSStreamReader(InputStream is, ColumnFactory cf, WarningsContext wc, boolean useVarLabels, boolean useValueLabels) {
        this.is = new SPSSInputStream(is);
        this.cf = cf;
        this.wc = wc;
        this.useVarLabels = useVarLabels;
        this.useValueLabels = useValueLabels;
    }

    public void parseHeader() throws IOException {
        this.meta = new Meta();
        if (!START_TOKEN.equals(this.is.readString(4))) {
            throw new IllegalArgumentException("Failed to parse file: it does not seem to be an SPSS .sav file.");
        }
        this.meta.productName = this.is.readString(60);
        this.meta.layoutCode = this.is.readInt();
        this.meta.littleEndian = false;
        if (this.meta.layoutCode != 2 && this.meta.layoutCode != 3) {
            int reversed = Integer.reverseBytes(this.meta.layoutCode);
            if (reversed == 2 || reversed == 3) {
                this.meta.layoutCode = reversed;
                this.is.setLittleEndian(true);
                this.meta.littleEndian = true;
            } else {
                throw new IllegalArgumentException("layoutCode should be 2 or 3, got " + this.meta.layoutCode);
            }
        }
        this.meta.nVariables = this.is.readInt();
        this.meta.compression = this.is.readInt();
        this.meta.weightVariableIndex = this.is.readInt();
        this.meta.nRecords = this.is.readInt();
        this.meta.compressionBias = this.is.readDouble();
        this.meta.creationDate = this.is.readString(9);
        this.meta.creationTime = this.is.readString(8);
        this.meta.fileLabel = this.is.readString(64);
        this.is.skipBytes(3);
        int maxIterations = 10000;
        block8: for (int i = 0; i < 10000; ++i) {
            int recordType = this.is.readInt();
            switch (recordType) {
                case 2: {
                    this.readVariable();
                    continue block8;
                }
                case 3: {
                    this.readValueLabel();
                    continue block8;
                }
                case 4: {
                    throw new IllegalArgumentException("Failed to parse header: encountered recordType 4 block without preceding recordType 3 block");
                }
                case 6: {
                    this.readDocumentRecord();
                    continue block8;
                }
                case 7: {
                    this.readOtherRecord();
                    continue block8;
                }
                case 999: {
                    this.expectInt(0, "invalid header end");
                    break block8;
                }
                default: {
                    throw new IllegalArgumentException("Failed to parse header: unexpected SPSS .sav record type: " + recordType);
                }
            }
        }
        for (VariableRecord var : this.vars) {
            String longName;
            Integer realLength;
            if (this.veryLongStrings != null && (realLength = this.veryLongStrings.variableLengths.get(var.name)) != null) {
                var.segments = (realLength + 251) / 252;
            }
            if (this.longVariableNames == null || !StringUtils.isNotBlank((String)(longName = this.longVariableNames.variableLongNames.get(var.name)))) continue;
            var.name = longName;
        }
        this.headerParsed = true;
    }

    private void readVariable() throws IOException {
        VariableRecord var = new VariableRecord();
        var.type = this.is.readInt();
        boolean hasLabel = this.is.readInt() > 0;
        var.missingValueFormatCode = this.is.readInt();
        var.printFormat = this.is.readNumericFormat();
        var.writeFormat = this.is.readNumericFormat();
        var.name = this.is.readString(8);
        if (hasLabel) {
            int len = this.is.readInt();
            var.label = this.is.readString(len);
            if (len % 4 != 0) {
                this.is.skipBytes(4 - len % 4);
            }
            if (this.useVarLabels && StringUtils.isNotBlank((String)var.label)) {
                var.name = var.label;
            }
        }
        if (var.missingValueFormatCode != 0) {
            this.is.skipBytes(Math.abs(var.missingValueFormatCode * 8));
        }
        if (var.type != -1) {
            logger.debug((Object)String.format("Variable record parsed. Type: %d, Label: %s, Name: %s", var.type, hasLabel ? var.label : "(none)", var.name));
            this.vars.add(var);
        }
    }

    private void readValueLabel() throws IOException {
        HashMap<List<Byte>, String> valueLabelsMap = new HashMap<List<Byte>, String>();
        int nLabels = this.is.readInt();
        for (int i = 0; i < nLabels; ++i) {
            byte[] value = new byte[8];
            this.is.read(value);
            int labelLength = this.is.read();
            String label = this.is.readString(labelLength);
            if ((labelLength + 1) % 8 != 0) {
                this.is.skipBytes(8 - (labelLength + 1) % 8);
            }
            valueLabelsMap.put(Arrays.asList(ArrayUtils.toObject((byte[])value)), label);
        }
        this.expectInt(4, "missing variable reference (recordType 4) after value label (recordType 3)");
        int nVariables = this.is.readInt();
        for (int i = 0; i < nVariables; ++i) {
            this.valueLabelRecords.put(this.is.readInt(), valueLabelsMap);
        }
        logger.debug((Object)String.format("Value labels record parsed. Found %d elements: %s", valueLabelsMap.size(), Arrays.toString(valueLabelsMap.values().toArray())));
    }

    private void readDocumentRecord() throws IOException {
        DocumentRecord doc = new DocumentRecord();
        int nLines = this.is.readInt();
        doc.lines = new String[nLines];
        for (int i = 0; i < nLines; ++i) {
            doc.lines[i] = this.is.readString(80);
        }
        logger.debug((Object)String.format("Document record parsed. Found %d elements: %s", nLines, Arrays.toString(doc.lines)));
    }

    private void readOtherRecord() throws IOException {
        int subType = this.is.readInt();
        switch (subType) {
            case 13: {
                this.readLongVariableNames();
                break;
            }
            case 14: {
                this.readVeryLongString();
                break;
            }
            case 20: {
                this.readEncoding();
                break;
            }
            default: {
                this.skipUnknownType7Record();
            }
        }
    }

    private void readLongVariableNames() throws IOException {
        String[] mappings;
        this.longVariableNames = new LongVariableNames();
        this.expectInt(1, "Long variable names record expects a 1 as length");
        int totalLength = this.is.readInt();
        String allNames = this.is.readString(totalLength);
        for (String mapping : mappings = allNames.split("\t")) {
            String[] arr = mapping.split("=");
            String shortName = arr[0];
            String longName = arr[1];
            this.longVariableNames.variableLongNames.put(shortName, longName);
        }
        logger.debug((Object)String.format("Long variable names record parsed. Found %d elements: %s", this.longVariableNames.variableLongNames.size(), this.longVariableNames.variableLongNames.toString()));
    }

    private void readVeryLongString() throws IOException {
        String[] mappings;
        this.veryLongStrings = new VeryLongStrings();
        this.expectInt(1, "Very long string record expects a 1 as length");
        int totalLength = this.is.readInt();
        String rawLengths = this.is.readString(totalLength);
        for (String mapping : mappings = rawLengths.split("\u0000\t")) {
            Integer variableLength;
            String[] arr = mapping.split("=");
            String variableName = arr[0];
            try {
                variableLength = Integer.parseInt(arr[1]);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Failed to parse the following very long string record: " + mapping);
            }
            this.veryLongStrings.variableLengths.put(variableName, variableLength);
        }
        logger.debug((Object)String.format("Very long string record parsed. Found %d elements: %s", this.veryLongStrings.variableLengths.size(), this.veryLongStrings.variableLengths.toString()));
    }

    private void readEncoding() throws IOException {
        EncodingMeta encoding = new EncodingMeta();
        this.expectInt(1, "Encoding record expects a 1 as length");
        int len = this.is.readInt();
        encoding.encoding = this.is.readString(len);
        try {
            this.is.setCharset(Charset.forName(encoding.encoding));
        }
        catch (IllegalArgumentException e) {
            this.wc.addWarning(WarningsContext.WarningType.INPUT_DATA_LINE_DOES_NOT_PARSE, "Failed to parse the encoding", (Throwable)e, logger);
        }
        logger.debug((Object)String.format("Encoding record parsed. Found: %s", encoding.encoding));
    }

    private void skipUnknownType7Record() throws IOException {
        int elemLength = this.is.readInt();
        int nElems = this.is.readInt();
        this.is.skip(elemLength * nElems);
    }

    private void expectInt(int expectedValue, String errorMsg) throws IOException {
        int value = this.is.readInt();
        if (expectedValue != value) {
            throw new IllegalArgumentException("Failed to parse header: " + errorMsg + " (got " + value + " rather than " + expectedValue + ")");
        }
    }

    public void readData(ProcessorOutput out, RowFactory rf) throws Exception {
        if (!this.headerParsed) {
            this.parseHeader();
        }
        for (int i = 0; i < this.meta.nRecords; ++i) {
            Row row = rf.row();
            int index = 1;
            Iterator<VariableRecord> iterator = this.vars.iterator();
            while (iterator.hasNext()) {
                String value;
                VariableRecord var = iterator.next();
                Column col = this.cf.column(var.name);
                if (var.isNumeric()) {
                    value = this.readNumber(var.writeFormat);
                    if (this.useValueLabels && this.valueLabelRecords.containsKey(index) && this.valueLabelRecords.get(index).containsKey(this.is.getLastByteArray())) {
                        row.put(col, this.valueLabelRecords.get(index).get(this.is.getLastByteArray()));
                    } else {
                        row.put(col, value);
                    }
                } else if (var.segments > 0) {
                    int remainingSegments = var.segments;
                    StringBuilder sb = new StringBuilder(this.readString(var.maxLength(), false));
                    while (iterator.hasNext() && --remainingSegments > 0) {
                        var = iterator.next();
                        sb.append(this.readString(var.maxLength(), false));
                    }
                    row.put(col, sb.toString().trim());
                } else {
                    value = this.readString(var.maxLength(), true);
                    if (this.useValueLabels && this.valueLabelRecords.containsKey(index) && this.valueLabelRecords.get(index).containsKey(this.is.getLastByteArray())) {
                        row.put(col, this.valueLabelRecords.get(index).get(this.is.getLastByteArray()));
                    } else {
                        row.put(col, value);
                    }
                }
                ++index;
            }
            out.emitRow(row);
        }
    }

    private String readNumber(NumericFormat format) throws IOException {
        Double res = this.meta.isCompressed() ? this.readCompressedNumber() : Double.valueOf(this.is.readDouble());
        if (res == null || res.isNaN()) {
            return null;
        }
        return this.formatNumber(res, format);
    }

    private String formatNumber(Double num, NumericFormat format) {
        if (num == null || Double.compare(num, MISSING_VALUE) == 0) {
            return null;
        }
        if (dateTypeToFormat.containsKey(format.type)) {
            SimpleDateFormat sdf = dateTypeToFormat.get(format.type);
            long msDate = (long)(num * 1000.0 - (double)GREGORIAN_CALENDAR_OFFSET.longValue());
            return sdf.format(new Date(msDate));
        }
        if (format.decimals == 0 && (double)num.intValue() == num) {
            return String.valueOf(num.intValue());
        }
        return num.toString();
    }

    private String readString(int len, boolean shouldTrim) throws IOException {
        String ret;
        if (this.meta.isCompressed()) {
            ret = this.readCompressedString(len, shouldTrim);
        } else {
            ret = this.is.readString(len, shouldTrim);
            if (len % 8 != 0) {
                this.is.skipBytes(8 - len % 8);
            }
        }
        return ret;
    }

    private String readString(int len) throws IOException {
        return this.readString(len, true);
    }

    private int getFlag() throws IOException {
        if (this.flagCursor < 0 || this.flagCursor > 7) {
            this.is.read(this.flagsBuffer);
            this.flagCursor = 0;
        }
        int ret = this.flagsBuffer[this.flagCursor] & 0xFF;
        ++this.flagCursor;
        return ret;
    }

    private Double readCompressedNumber() throws IOException {
        int byteValue = this.getFlag();
        Double ret = null;
        switch (byteValue) {
            case 0: {
                break;
            }
            case 252: {
                throw new IllegalArgumentException("Failed to parse header: end of stream");
            }
            case 253: {
                ret = this.is.readDouble();
                break;
            }
            case 254: 
            case 255: {
                ret = Double.NaN;
                break;
            }
            default: {
                ret = (double)byteValue - this.meta.compressionBias;
                this.is.buff = this.is.toByteArray(ret);
            }
        }
        return ret;
    }

    private String readCompressedString(int len, boolean shouldTrim) throws IOException {
        int nBlocks = (len - 1) / 8 + 1;
        String ret = "";
        block7: for (int i = 0; i < nBlocks; ++i) {
            int flag = this.getFlag();
            switch (flag) {
                case 0: {
                    continue block7;
                }
                case 252: {
                    throw new IllegalArgumentException("Failed to parse header: end of stream");
                }
                case 253: {
                    int nBytes = Math.min(8, len - 8 * i);
                    ret = ret + this.is.readString(nBytes, false);
                    if (nBytes >= 8) continue block7;
                    this.is.skipBytes(8 - nBytes);
                    continue block7;
                }
                case 254: {
                    ret = ret + "        ";
                    continue block7;
                }
                case 255: {
                    throw new IllegalArgumentException("Failed to parse header: string cannot be missing");
                }
                default: {
                    throw new IllegalArgumentException("Failed to parse header: unknown compression code" + flag);
                }
            }
        }
        return shouldTrim ? ret.trim() : ret;
    }

    private String readCompressedString(int len) throws IOException {
        return this.readCompressedString(len, true);
    }

    static {
        HashMap<Integer, SimpleDateFormat> tmpMap = new HashMap<Integer, SimpleDateFormat>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        for (int dateType : new int[]{20, 23, 24, 26, 27, 28, 29, 30, 38, 39}) {
            tmpMap.put(dateType, dateFormat);
        }
        tmpMap.put(21, timeFormat);
        tmpMap.put(22, dateTimeFormat);
        tmpMap.put(25, dateTimeFormat);
        dateTypeToFormat = Collections.unmodifiableMap(tmpMap);
    }

    static class EncodingMeta {
        String encoding;

        EncodingMeta() {
        }
    }

    static class VeryLongStrings {
        Map<String, Integer> variableLengths = new HashMap<String, Integer>();

        VeryLongStrings() {
        }
    }

    static class LongVariableNames {
        Map<String, String> variableLongNames = new HashMap<String, String>();

        LongVariableNames() {
        }
    }

    static class DocumentRecord {
        String[] lines;

        DocumentRecord() {
        }
    }

    static class VariableRecord {
        int type;
        int segments;
        String name;
        String label;
        int missingValueFormatCode;
        NumericFormat printFormat;
        NumericFormat writeFormat;

        VariableRecord() {
        }

        boolean isNumeric() {
            return this.type == 0;
        }

        int maxLength() {
            if (this.isNumeric()) {
                throw new IllegalStateException("Numeric variable has no length");
            }
            return this.type;
        }
    }

    static class NumericFormat {
        int decimals;
        int width;
        int type;

        NumericFormat() {
        }
    }

    static class Meta {
        boolean littleEndian;
        int compression;
        double compressionBias;
        int nRecords;
        String productName;
        int layoutCode;
        int nVariables;
        int weightVariableIndex;
        String creationDate;
        String creationTime;
        String fileLabel;

        Meta() {
        }

        boolean isCompressed() {
            return this.compression != 0;
        }
    }
}

