from typing import Any, Dict, List


def get_queries_by_db_id(
    queries: List[Dict[str, Any]], db_id: str
) -> List[Dict[str, Any]]:
    return [query for query in queries if query["db_id"] == db_id]


def group_queries_by_db_id(queries: List[Dict[str, Any]]) -> List[Dict[str, Any]]:
    groups: Dict[str, List[Dict[str, Any]]] = {}
    for query in queries:
        db_id: str = query["db_id"]
        if db_id not in groups:
            groups[db_id] = []
        groups[db_id].append(query)

    group_summaries: List[Dict[str, Any]] = []
    for db_id, query_list in groups.items():
        group_summaries.append(
            {"db_id": db_id, "count": len(query_list), "queries": query_list}
        )

    return group_summaries


def get_golden_query(queries, query_id: str):
    for query in queries:
        if query["query_id"] == query_id:
            return query
    return None
