//if you also want to show the name of the group (removed because it can overcrowd the chart)
//var labelFilter = (obj) => obj.dataIndex === 1 ? obj.seriesName ' + time=' + obj.value : '';
var labelFilter = (obj) => obj.dataIndex === 1 ? obj.value : '';

const labelOption = {
  show: true,
  rotate: 90,
  formatter: labelFilter,
  
  fontSize: 12,
  rich: {
    time: {
      color: '#999'
    }
  }
};


function get_extended_data(data, config, y_column_name, group_value){ 
  
    const extendedArray = [];
    let previousY = 1;

    data_filtered = data.filter(
      function(point){
        return point[config.groupby_column_name] == group_value;
      }
    );
    // unique time points among the union of all times for all groups
    const unique_times = [... new Set(data.map(point => point[config.timeline_column_name]))];
    for (const xValue of unique_times){
      const group_times = data_filtered.map(point => point[config.timeline_column_name])
      if(xValue == Math.max(...group_times)){
        break;
      }
      const existingPoint = data_filtered.find(point => point[config.timeline_column_name] == xValue);
      if (existingPoint) {
        previousY = existingPoint[y_column_name];
      }
      extendedArray.push([xValue, previousY]);  
    }
    return extendedArray
  
}

function get_group_values(data, config){
  // get the list of unique group values that will be displayed in chart
  
  const groupby_column = data.map(point => point[config.groupby_column_name]);

  let groupCount = {};
  groupby_column.forEach((value) => {
    groupCount[value] = (groupCount[value] || 0) + 1;
  });
  // Create an object with all the group values appearing only once
  // and sorted by decreasing count of groups
  let group_values = [...new Set(groupby_column)].sort((a, b) => {
    return groupCount[b] - groupCount[a];
  });;

  // Truncate object if length exceeds the maximum number of curves to display
  group_values.length = Math.min(group_values.length, config.max_displayed_values)

  return group_values
}
