// file that contains all the objects that are drawn in the chart

const survival_line_name = "survival line"

function getSurvivalCurve(data, config, group_value){
  const survival_curve = {
    name: group_value,
    type: 'line',
    id: 'function' + group_value,
    data: get_extended_data(data, config, config.survival_probas_column_name, group_value),
    lineStyle: {
      opacity: 1
    },
    symbol: 'circle',
    symbolSize: 2,
    itemStyle: {
    },
    emphasis: {
      focus: 'series'
    },
    step: 'start'
  }
  return survival_curve
};

function getHorizontalSurvivalLine(config, data){
  const max_time = Math.max(...data.map(point => point[config.timeline_column_name]));

  const horizontal_survival_line = {
    name: survival_line_name,
    type: 'line',
    data: [
      [0, config.survival_line_proba],
      [max_time, config.survival_line_proba]
    ],
    lineStyle: {
      opacity: 1,
      type: 'dashed',
      color: 'black'
    },
    //symbol: 'none', for tooltip??
    emphasis: {
      focus: 'series'
    }
  }
  return horizontal_survival_line
}

function getVerticalQuantileLine(data, config, group_value){

  const goal = config.survival_line_proba;
  // get the point at which the horizontal survival line intersects the curve
  const initial_y_value = data[0][1]
  // initial_relative_position = 1 if the function is above horizontal line, -1 if below
  const initial_relative_position = Math.sign(initial_y_value - goal)
  let last_curve_point_before_intersection = data.findLast(point => Math.sign(point[1] - goal) == initial_relative_position)

  // if the curve never intersects the horizontal reference line, then set the vertical line to the last data point
  if (last_curve_point_before_intersection == undefined){
    last_curve_point_before_intersection = data[data.length - 1]
  }

  const intersection_point = [last_curve_point_before_intersection[0], goal]

  const vertical_quantile_line = {
    name: group_value,
    type: 'line',
    label: labelOption,
    data: [
      intersection_point,
      [intersection_point[0], 0]
    ],
    
    lineStyle: {
      opacity: 1,
      type: 'dashed'
    },

    //symbol: 'none', for tooltip??
    emphasis: {
      focus: 'series'
    }
  };

  return vertical_quantile_line
}

function getConfidenceIntervals(data, config, group_value) {
    
    const lower_confidence_data = get_extended_data(data, config, config.lower_confidence_column_name, group_value)
    const lower_confidence = {
      name: group_value,
      // workaround: add group_value string to make all ids unique...
      id: 'lower' + group_value,
      type: 'line',
      data: lower_confidence_data,
      lineStyle: {
        opacity: 0
      },
    stack: group_value,
      symbol: 'none',
      emphasis: {
        focus: 'series'
      }
    };
  
    let upper_confidence_data = get_extended_data(data, config, config.upper_confidence_column_name, group_value)
    upper_confidence_data = upper_confidence_data.map(function(point, ind){
      return [point[0], point[1] - lower_confidence_data[ind][1]]
    })
  
  
    const upper_confidence = {
      name: group_value,
      // workaround: add group_value string to make all ids unique...
      id: 'upper' + group_value,
      type: 'line',
      data: upper_confidence_data,
      lineStyle: {
        opacity: 0
      },
      areaStyle: {
        opacity: config.confidence_interval_opacity_percentage / 100
      },
      stack: group_value,
      symbol: 'none',
      emphasis: {
        focus: 'series'
      }
    };
  
    return{
      lowerConfidence: lower_confidence,
      upperConfidence: upper_confidence
    }
};
  