let webAppConfig = dataiku.getWebAppConfig()['webAppConfig'];
let webAppDesc = dataiku.getWebAppDesc()['chart']

var chart = echarts.init(document.getElementById('confidence-interval-chart'));
        
var chartHeight = document.body.getBoundingClientRect().height;
var chartWidth = document.body.getBoundingClientRect().width;


window.parent.postMessage("sendConfig", "*");

window.addEventListener('resize', function() {
  chart.resize();
});

window.addEventListener('message', function(event) {
    
    if (event.data) {

        event_data = JSON.parse(event.data);
        webAppConfig = event_data['webAppConfig']
        filters = event_data['filters']

        // TODO catch when filter all alphanum column type values
        try {
            checkWebAppParameters(webAppConfig, webAppDesc);
        } catch (e) {

            dataiku.webappMessages.displayFatalError(e.message);
            return;
        }

        try {
            checkWebAppConfig(webAppConfig)
        } catch (e) {
            dataiku.webappMessages.displayFatalError(e.message);
            return;
        }
        
        var config = {
          dataset_name: webAppConfig['dataset'],
          timeline_column_name: webAppConfig['timeline'],
          survival_probas_column_name: webAppConfig['survival_probas'],
          lower_confidence_column_name: webAppConfig['lower_confidence'],
          upper_confidence_column_name: webAppConfig['upper_confidence'],
          groupby_column_name: webAppConfig['groupby'],
          max_displayed_values: webAppConfig['max_displayed_values'],
          show_confidence_intervals: webAppConfig['show_confidence_intervals'],
          confidence_interval_opacity_percentage: webAppConfig['confidence_interval_opacity_percentage'],
          show_survival_line: webAppConfig['show_survival_line'],
          survival_line_proba: webAppConfig['survival_line_proba_percentage'] / 100
        }
        dataiku.webappBackend.get('reformat_data', {"config": JSON.stringify(config), "filters": JSON.stringify(filters)})
            .then(
                function(data){
                    drawChart(chart, data, config);
                }
            ).catch(error => {
            dataiku.webappMessages.displayFatalError(error);
                              }
              );
    }
});
