/*
 * Decompiled with CFR 0.152.
 */
package com.titanml.llm;

import com.dataiku.common.rpc.ExternalJSONAPIClient;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.llm.utils.OnlineLLMUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.http.client.RedirectStrategy;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.LaxRedirectStrategy;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.titanml.llm.TitanMLLLMConnector;
import java.io.IOException;
import java.util.function.Consumer;

public class TitanMLLLMSnowflakeConnector
extends TitanMLLLMConnector {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.titanml");

    @Override
    public void init(PluginSettingsResolver.ResolvedSettings settings) {
        super.init(settings);
        logger.info((Object)"Adding snowflake functionality-----------------------------------");
        JsonElement snowflakeAccountURL = settings.config.get("snowflakeAccountUrl");
        JsonElement snowflakeTokenPreset = settings.config.get("oauth");
        String access_token = null;
        Consumer<HttpClientBuilder> customizeBuilderCallback = builder -> {
            builder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings = new AbstractLLMConnection.HTTPBasedLLMNetworkSettings();
            OnlineLLMUtils.add429RetryStrategy((HttpClientBuilder)builder, (AbstractLLMConnection.HTTPBasedLLMNetworkSettings)networkSettings);
        };
        if (snowflakeTokenPreset != null && !snowflakeTokenPreset.getAsJsonObject().entrySet().isEmpty()) {
            access_token = snowflakeTokenPreset.getAsJsonObject().get("snowflake_oauth").getAsString();
        }
        if (access_token == null || snowflakeAccountURL.getAsString().isEmpty()) {
            logger.info((Object)"No snowflake oauth token or snowflake account url found in settings. This won't work for snowflake connection but will work for local takeoff");
        } else {
            logger.info((Object)"Snowflake oauth token and snowflake account url found in settings. Use snowflake connection");
            try (ExternalJSONAPIClient tokenClient = new ExternalJSONAPIClient(snowflakeAccountURL.getAsString(), null, true, null, customizeBuilderCallback);){
                JsonObject tokenRequestBody = new JsonObject();
                tokenRequestBody.addProperty("AUTHENTICATOR", "OAUTH");
                tokenRequestBody.addProperty("TOKEN", access_token);
                JsonObject trData = new JsonObject();
                trData.add("data", (JsonElement)tokenRequestBody);
                JsonObject tokenResp = (JsonObject)tokenClient.postObjectToJSON("/session/v1/login-request", JsonObject.class, (Object)trData);
                String sessionStr = tokenResp.get("data").getAsJsonObject().get("token").getAsString();
                String snowflakeToken = "Snowflake Token=\"" + sessionStr + "\"";
                super.setHeaders("Authorization", snowflakeToken);
            }
            catch (IOException e) {
                logger.error((Object)"SPCS session token exchange failed", (Throwable)e);
            }
        }
    }
}

