import { createPinia } from 'pinia'
import { createApp } from 'vue'

import App from './src/App.vue'

import { registerDirectives } from './src/directives/register';
// load prism components
import 'prismjs/themes/prism-tomorrow.css'
import 'prismjs/components/prism-javascript'; // JavaScript
import 'prismjs/components/prism-typescript'; // TypeScript
import 'prismjs/components/prism-css'; // CSS
import 'prismjs/components/prism-scss'; // SCSS
import 'prismjs/components/prism-json'; // JSON
import 'prismjs/components/prism-markup'; // XML, HTML, SVG, MathML, etc.
import 'prismjs/components/prism-bash'; // Bash/Shell
import 'prismjs/components/prism-python'; // Python
import 'prismjs/components/prism-java'; // Java
import 'prismjs/components/prism-csharp'; // C#
import 'prismjs/components/prism-c'; // C
import 'prismjs/components/prism-cpp'; // C++

import './style.css'
import 'tabulator-tables/dist/css/tabulator.min.css'
import 'tabulator-tables/dist/css/tabulator_simple.min.css'
import 'vue-json-pretty/lib/styles.css'
import 'vue-sonner/style.css'

export const myApp = createApp(App)

registerDirectives(myApp);

const pinia = createPinia()
myApp.use(pinia)
myApp.mount('#app')
