import { toast } from 'vue-sonner'
export async function copyToClipboard(value: any) {
  try {
    const valueString = typeof value === 'string' ? value : JSON.stringify(value)
    await navigator?.clipboard?.writeText(valueString)
    toast.info('Copied')
  } catch (err) {
    toast.error("Couldn't copy to clipboard.")
  }
}
