from typing import Any, List

from typing_extensions import Literal, TypedDict


class RunCypherSuccess(TypedDict):
    success: bool
    nodes: List
    edges: List
    table: Any


class RunCypherFailure(TypedDict):
    success: bool
    errorCode: Literal[
        "INVALID_CYPHER_ERROR",
        "BROKEN_DB_STATE_ERROR",
        "UNEXPECTED_ERROR",
    ]
    error: str


class RunLlmCypherSuccess(RunCypherSuccess):
    cypher_query: str


class RunLlmCypherFailure(RunCypherFailure):
    cypher_query: str
