def get_user_prompt(schema: str, question: str) -> str:
    """
    Generates a prompt for an LLM to create a Kùzu Cypher query based on a provided graph schema and user question.

    Args:
        schema (str): The graph schema to be used for query generation.
        question (str): The user's natural language question about the graph.

    Returns:
        str: A formatted prompt string instructing the LLM to generate a Kùzu Cypher query.
    """
    return f"""
    Given the following graph schema generate the Kùzu Cypher query to answer the user question.
    ### Database Schema (Kùzu)
    {schema}

    ---
    ### Now generate a valid Cypher query based on this user request:
    **User Question**: {question}
    """
