import dataiku


def do(payload, config, plugin_config, inputs):
    client = dataiku.api_client()

    supported_connection_types = ["Filesystem", "EC2"] 

    # python API does not allow the usage of parameter "checkAllowManagedFolders" so we perform GET directly
    supported_connections_per_type_with_allowed_managed_folders = [client._perform_json("GET", "/connections/get-names", params={"type": supported_type, "checkAllowManagedFolders": True})
                                                                   for supported_type in supported_connection_types]

    supported_connection_names = []
    for supported_connection_names_per_type in supported_connections_per_type_with_allowed_managed_folders:
        for name in supported_connection_names_per_type:
            supported_connection_names.append(name)
            
    return {"choices": [{"value": name, "label": name} for name in supported_connection_names]}