from flask import Blueprint

from editor.backend.utils.api import use_graph_snapshot_store
from editor.backend.utils.webapp_config import webapp_config
from solutions.backend.utils import return_ok
from solutions.graph.store.graph_metadata_snapshot_store import GraphMetadataSnapshotStore

config = Blueprint("config", __name__, url_prefix="/config")


@config.route("/webapp", methods=["GET"])
@use_graph_snapshot_store
def get_webapp_config(snapshot_store: GraphMetadataSnapshotStore):
    data = {
        "llm_id": webapp_config.llm_id,
        "snapshot_feature_available": snapshot_store is not None,
        "publishFeatureAvailable": webapp_config.build_graph_recipe_output_connection is not None,
    }

    return return_ok(data=data)
