from __future__ import annotations

import logging

from flask import Blueprint, request

from solutions.backend.utils import return_ok
from solutions.graph.graph_db_instance_manager import EditorWebAppDbInstance
from solutions.graph.queries.graph_data import compute_adjacent_node_groups_info, compute_total_counts
from solutions.graph.queries.params import ComputeAdjacentNodeGroupInfoParams

logger = logging.getLogger(__name__)

graph_queries = Blueprint("graph_queries", __name__, url_prefix="/queries")


@graph_queries.route("/<graph_id>/computeAdjacentNodeGroupsInfo", methods=["POST"])
def get_adjacent_node_groups(graph_id: str):
    params = ComputeAdjacentNodeGroupInfoParams(**request.get_json())

    with EditorWebAppDbInstance(graph_id, readonly=True) as db_instance:
        return return_ok(compute_adjacent_node_groups_info(db_instance, params))

@graph_queries.route("/<graph_id>/getTotalCounts", methods=["GET"])
def get_total_counts(graph_id: str):
    with EditorWebAppDbInstance(graph_id, readonly=True) as db_instance:
        return return_ok(compute_total_counts(db_instance))
