import os
import tempfile
import uuid


def get_or_create_diskcache_dir(env_var: str, dir_name_prefix: str) -> str:
    """
    Create a shared temporary cache path per webapp run.
    The generated path is shared across processes via an env variable.
    """
    if env_var in os.environ:
        return os.environ[env_var]

    cache_dir = os.path.join(tempfile.gettempdir(), f"{dir_name_prefix}{uuid.uuid4().hex[:8]}")
    os.makedirs(cache_dir, exist_ok=True)

    os.environ[env_var] = cache_dir
    return cache_dir
