from __future__ import annotations

from .diskcache import get_or_create_diskcache_dir

ENV_VAR_GRAPH_DISK_CACHE_DIR = "VGE_GRAPH_DISKCACHE_DIR"
ENV_VAR_SNAPSHOT_DISK_CACHE_DIR = "VGE_SNAPSHOT_DISKCACHE_DIR"
ENV_VAR_KUZU_DB_INSTANCE_ACCESS_DISK_CACHE_DIR = "VGE_KUZU_DB_INSTANCE_ACCESS_DISKCACHE_DIR"


def get_or_create_graph_diskcache_dir() -> str:
    """
    Create a shared temporary cache path per webapp run.
    The generated path is shared across processes via an env variable.
    """
    return get_or_create_diskcache_dir(ENV_VAR_GRAPH_DISK_CACHE_DIR, "vge_graph_cache_")


def get_or_create_snapshot_diskcache_dir() -> str:
    """
    Create a shared temporary cache path per webapp run.
    The generated path is shared across processes via an env variable.
    """
    return get_or_create_diskcache_dir(ENV_VAR_SNAPSHOT_DISK_CACHE_DIR, "vge_snapshot_cache_")


def get_or_create_kuzu_db_instance_access_diskcache_dir() -> str:
    """
    Create a shared temporary cache path per webapp run.
    The generated path is shared across processes via an env variable.
    """
    return get_or_create_diskcache_dir(ENV_VAR_KUZU_DB_INSTANCE_ACCESS_DISK_CACHE_DIR, "vge_kuzu_db_instance_access_")
