from flask import Flask
from flask_cors import CORS

from solutions.llm.logging_dataset import logging_dataset


def run_create_app(app: Flask, testing_context: bool = False):
    from solutions.backend.logging_setup import logging_setup

    logging_setup()

    if not testing_context:
        from .webapp_config import webapp_config

        webapp_config.setup()

        if webapp_config.logging_ds:
            logging_dataset.init(webapp_config.logging_ds)

    from explorer.backend.api import api

    CORS(app)

    app.register_blueprint(api)

    return app
