from __future__ import annotations

import json

from dataiku import Folder
from typing_extensions import TypedDict


class GCSCredentials(TypedDict):
    bucket: str
    project_id: str
    root_prefix: str
    access_key_id: str
    secret_access_key: str


def get_gcs_credentials(folder: Folder) -> GCSCredentials:
    folder_info = folder.get_info(sensitive_info=True)
    if folder_info["type"] != "GCS":
        raise Exception("Expected a GCS folder.")

    access_info = folder_info["accessInfo"]
    bucket_name = access_info["bucket"]
    project_id = access_info["projectId"]
    root_prefix = access_info["root"]

    app_secret_content = json.loads(access_info["appSecretContent"])

    return GCSCredentials(
        bucket=bucket_name,
        project_id=project_id,
        root_prefix=root_prefix,
        access_key_id=app_secret_content["private_key_id"],
        secret_access_key=app_secret_content["private_key"],
    )
