from solutions.graph.models import (  # noqa: F401
    FeatureUnavailableError,
    GraphAlreadyExistsError,
    GraphDBDoesNotExistError,
    GraphDoesNotExistError,
    ModelValidationError,
    SnapshotDoesNotExistError,
)
from solutions.graph.store.graph_metadata_store import ConcurrentUpdateCollisionError


def create_app():
    from explorer.backend.utils.launch_utils import run_create_app

    run_create_app(app)  # type: ignore

    from pydantic import ValidationError
    from solutions.backend.middlewares import (
        handle_concurrent_update_error,
        handle_feature_unavailable_error,
        handle_graph_already_exists_error,
        handle_graph_db_not_exist_error,
        handle_graph_does_not_exist_error,
        handle_model_validation_error,
        handle_snapshot_does_not_exist_error,
        handle_unexpected_error,
        handle_validation_error,
    )

    app.register_error_handler(ValidationError, handle_validation_error)  # type: ignore
    app.register_error_handler(GraphDoesNotExistError, handle_graph_does_not_exist_error)  # type: ignore
    app.register_error_handler(GraphAlreadyExistsError, handle_graph_already_exists_error)  # type: ignore
    app.register_error_handler(GraphDBDoesNotExistError, handle_graph_db_not_exist_error)  # type: ignore
    app.register_error_handler(ConcurrentUpdateCollisionError, handle_concurrent_update_error)  # type: ignore
    app.register_error_handler(SnapshotDoesNotExistError, handle_snapshot_does_not_exist_error)  # type: ignore
    app.register_error_handler(FeatureUnavailableError, handle_feature_unavailable_error)  # type: ignore
    app.register_error_handler(ModelValidationError, handle_model_validation_error)  # type: ignore
    app.register_error_handler(Exception, handle_unexpected_error)  # type: ignore
    return app  # type: ignore


create_app()
