/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

import com.fasterxml.sort.DataReader;
import com.fasterxml.sort.SortConfig;
import com.fasterxml.sort.std.TextFileSorter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;

public class SortedPathIterator
implements Iterator<Path> {
    private final Iterator<byte[]> sortedIter;

    public SortedPathIterator(final Iterator<Path> iter) throws IOException {
        SortConfig config = new SortConfig().withMaxMemoryUsage(1000000L);
        TextFileSorter sorter = new TextFileSorter(config);
        DataReader<byte[]> reader = new DataReader<byte[]>(){

            public byte[] readNext() throws IOException {
                if (!iter.hasNext()) {
                    return null;
                }
                return ((Path)iter.next()).toString().getBytes(StandardCharsets.UTF_8);
            }

            public void close() throws IOException {
            }

            public int estimateSizeInBytes(byte[] item) {
                return item.length;
            }
        };
        this.sortedIter = sorter.sort((DataReader)reader);
    }

    @Override
    public boolean hasNext() {
        return this.sortedIter.hasNext();
    }

    @Override
    public Path next() {
        File f = new File(new String(this.sortedIter.next(), StandardCharsets.UTF_8));
        return f.toPath();
    }
}

