/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum;

import io.warp10.continuum.store.Constants;
import io.warp10.sensision.Sensision;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class TimeSource {
    static long baseMillis = 0L;
    static long baseNanos = 0L;
    static long baseTimeunits = 0L;
    static long lastCalibration = 0L;
    static AtomicLong calibrations = new AtomicLong(0L);
    static AtomicBoolean mustRecalibrate = new AtomicBoolean(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void calibrate() {
        if (System.currentTimeMillis() - lastCalibration < 1000L) {
            Sensision.update((String)"warp.timesource.calibrations.skipped", (Map)Sensision.EMPTY_LABELS, (Number)1);
            return;
        }
        long myBaseMillis = System.currentTimeMillis();
        long myBaseNanos = System.nanoTime();
        lastCalibration = myBaseMillis;
        boolean first = true;
        long lastms = 0L;
        int count = 0;
        int SAMPLES = 1000;
        long[] bases = new long[SAMPLES];
        while (count < SAMPLES) {
            long ms = System.currentTimeMillis();
            long ns = System.nanoTime();
            long msdelta = ms - myBaseMillis;
            long nsdelta = ns - myBaseNanos;
            if (first) {
                lastms = ms;
                first = false;
                continue;
            }
            if (lastms != ms) {
                bases[count] = myBaseNanos += nsdelta - msdelta * 1000000L;
                ++count;
            }
            lastms = ms;
        }
        Arrays.sort(bases);
        int mostocc = 0;
        int curocc = 1;
        int mostoccidx = -1;
        int curidx = 0;
        long lastval = bases[0];
        for (int idx = 1; idx < SAMPLES; ++idx) {
            if (bases[curidx] != lastval) {
                if (curocc > mostocc) {
                    mostocc = curocc;
                    mostoccidx = curidx;
                }
                curidx = idx;
                curocc = 1;
                continue;
            }
            ++curocc;
        }
        if (curocc > mostocc) {
            mostocc = curocc;
            mostoccidx = curidx;
        }
        AtomicBoolean atomicBoolean = mustRecalibrate;
        synchronized (atomicBoolean) {
            baseNanos = bases[mostoccidx];
            baseMillis = myBaseMillis;
            baseTimeunits = baseMillis * Constants.TIME_UNITS_PER_MS;
        }
        calibrations.addAndGet(1L);
        Sensision.update((String)"warp.timesource.calibrations", (Map)Sensision.EMPTY_LABELS, (Number)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long getTime() {
        long ts;
        while (0L == calibrations.get()) {
        }
        AtomicBoolean atomicBoolean = mustRecalibrate;
        synchronized (atomicBoolean) {
            long nano = System.nanoTime();
            ts = baseTimeunits + (nano -= baseNanos) / Constants.NS_PER_TIME_UNIT;
        }
        long ms = System.currentTimeMillis();
        long delta = ts / Constants.TIME_UNITS_PER_MS - ms;
        if (delta > 0L) {
            mustRecalibrate.set(true);
            return ms * Constants.TIME_UNITS_PER_MS;
        }
        if (delta <= -1L && 0.9 * (double)Constants.TIME_UNITS_PER_MS > (double)(ts % Constants.TIME_UNITS_PER_MS)) {
            mustRecalibrate.set(true);
            return ms * Constants.TIME_UNITS_PER_MS;
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNanoTime() {
        while (0L == calibrations.get()) {
        }
        AtomicBoolean atomicBoolean = mustRecalibrate;
        synchronized (atomicBoolean) {
            long nano = System.nanoTime();
            return baseMillis * 1000000L + (nano -= baseNanos);
        }
    }

    static {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    if (!mustRecalibrate.getAndSet(false)) {
                        LockSupport.parkNanos(100000000L);
                        continue;
                    }
                    TimeSource.calibrate();
                    LockSupport.parkNanos(100000000L);
                }
            }
        });
        t.setDaemon(true);
        t.setName("[TimeSource Calibrator]");
        t.start();
    }
}

