/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.WarpScriptException;
import io.warp10.script.functions.STL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.TDistribution;

public class GTSOutliersHelper {
    protected static void doubleCheck(GeoTimeSerie gts) throws WarpScriptException {
        if (GeoTimeSerie.TYPE.DOUBLE != gts.type) {
            throw new WarpScriptException("GTS must be of type Double.");
        }
    }

    protected static double mean(GeoTimeSerie gts) throws WarpScriptException {
        double mean = 0.0;
        for (int i = 0; i < gts.values; ++i) {
            mean += gts.doubleValues[i];
        }
        if (0 == gts.values) {
            throw new WarpScriptException("Can't compute mean as gts is empty");
        }
        return mean / (double)gts.values;
    }

    protected static double median(GeoTimeSerie gts) {
        double[] copy = Arrays.copyOf(gts.doubleValues, gts.values);
        Arrays.sort(copy);
        return gts.values % 2 == 0 ? (copy[gts.values / 2] + copy[gts.values / 2 - 1]) / 2.0 : copy[gts.values / 2];
    }

    protected static double medianAbsoluteDeviation(GeoTimeSerie gts, double median) {
        double[] copy = Arrays.copyOf(gts.doubleValues, gts.values);
        for (int i = 0; i < gts.values; ++i) {
            int n = i;
            copy[n] = copy[n] - median;
            copy[i] = Math.abs(copy[i]);
        }
        Arrays.sort(copy);
        return gts.values % 2 == 0 ? (copy[gts.values / 2] + copy[gts.values / 2 - 1]) / 2.0 : copy[gts.values / 2];
    }

    protected static double max(GeoTimeSerie gts) throws WarpScriptException {
        double max = gts.doubleValues[0];
        if (Double.isNaN(max)) {
            throw new WarpScriptException("Method max: GTS contains NaN");
        }
        for (int i = 1; i < gts.values; ++i) {
            if (!(max < gts.doubleValues[i])) continue;
            max = gts.doubleValues[i];
        }
        return max;
    }

    protected static double min(GeoTimeSerie gts) throws WarpScriptException {
        double min = gts.doubleValues[0];
        if (Double.isNaN(min)) {
            throw new WarpScriptException("Method min: GTS contains NaN");
        }
        for (int i = 1; i < gts.values; ++i) {
            if (!(min > gts.doubleValues[i])) continue;
            min = gts.doubleValues[i];
        }
        return min;
    }

    protected static double[] madsigma(GeoTimeSerie gts, boolean useMedian) {
        double[] madsigma = null;
        if (!useMedian) {
            madsigma = GTSHelper.musigma(gts, true);
        } else {
            madsigma = new double[]{GTSOutliersHelper.median(gts), GTSOutliersHelper.medianAbsoluteDeviation(gts, madsigma[0])};
            madsigma[1] = 0.0 != madsigma[1] ? madsigma[1] / 0.6745 : GTSHelper.musigma(gts, true)[1];
        }
        return madsigma;
    }

    public static GeoTimeSerie zScore(GeoTimeSerie gts, boolean useMedian, boolean inplace) throws WarpScriptException {
        GTSOutliersHelper.doubleCheck(gts);
        double[] musigma = GTSOutliersHelper.madsigma(gts, useMedian);
        double m = musigma[0];
        double std = musigma[1];
        if (0.0 == std) {
            throw new WarpScriptException((useMedian ? "Standard" : "Median Absolute") + " Deviation is null");
        }
        GeoTimeSerie gts_ = inplace ? gts : gts.clone();
        for (int i = 0; i < gts_.values; ++i) {
            gts_.doubleValues[i] = (gts_.doubleValues[i] - m) / std;
        }
        return gts_;
    }

    public static List<Long> thresholdTest(GeoTimeSerie gts, double threshold, boolean abs) throws WarpScriptException {
        GTSOutliersHelper.doubleCheck(gts);
        ArrayList<Long> anomalous_ticks = new ArrayList<Long>();
        for (int i = 0; i < gts.values; ++i) {
            if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                double temp = gts.doubleValues[i];
                if (abs) {
                    temp = Math.abs(temp);
                }
                if (!(temp >= threshold)) continue;
                anomalous_ticks.add(gts.ticks[i]);
                continue;
            }
            if (GeoTimeSerie.TYPE.LONG != gts.type) continue;
            long temp = gts.longValues[i];
            if (abs) {
                temp = Math.abs(temp);
            }
            if (!((double)temp >= threshold)) continue;
            anomalous_ticks.add(gts.ticks[i]);
        }
        return anomalous_ticks;
    }

    public static List<Long> thresholdTest(GeoTimeSerie gts, double threshold) throws WarpScriptException {
        return GTSOutliersHelper.thresholdTest(gts, threshold, true);
    }

    public static List<Long> zScoreTest(GeoTimeSerie gts, boolean useMedian, double d) throws WarpScriptException {
        GTSOutliersHelper.doubleCheck(gts);
        ArrayList<Long> anomalous_ticks = new ArrayList<Long>();
        double[] musigma = GTSOutliersHelper.madsigma(gts, useMedian);
        double m = musigma[0];
        double std = musigma[1];
        if (0.0 == std) {
            return anomalous_ticks;
        }
        for (int i = 0; i < gts.values; ++i) {
            double z = (gts.doubleValues[i] - m) / std;
            if (!(Math.abs(z) >= d)) continue;
            anomalous_ticks.add(gts.ticks[i]);
        }
        return anomalous_ticks;
    }

    public static List<Long> grubbsTest(GeoTimeSerie gts, boolean useMedian, double alpha) throws WarpScriptException {
        GTSOutliersHelper.doubleCheck(gts);
        ArrayList<Long> anomalous_ticks = new ArrayList<Long>();
        int N = gts.values;
        if (N < 3) {
            return anomalous_ticks;
        }
        double[] musigma = GTSOutliersHelper.madsigma(gts, useMedian);
        double m = musigma[0];
        double std = musigma[1];
        if (0.0 == std) {
            return anomalous_ticks;
        }
        double z = 0.0;
        double max = Double.NEGATIVE_INFINITY;
        long suspicious_tick = 0L;
        for (int i = 0; i < N; ++i) {
            z = Math.abs((gts.doubleValues[i] - m) / std);
            if (!(z > max)) continue;
            max = z;
            suspicious_tick = gts.ticks[i];
        }
        double t = new TDistribution((double)(N - 2)).inverseCumulativeProbability(alpha / (double)(2 * N));
        double Ginf = (double)(N - 1) * Math.abs(t) / Math.sqrt((double)N * ((double)(N - 2) + t * t));
        if (max > Ginf) {
            anomalous_ticks.add(suspicious_tick);
        }
        return anomalous_ticks;
    }

    public static List<Long> grubbsTest(GeoTimeSerie gts, boolean useMedian) throws WarpScriptException {
        return GTSOutliersHelper.grubbsTest(gts, useMedian, 0.05);
    }

    public static List<Long> tietjenMooreTest(GeoTimeSerie gts, int k, boolean useMedian, double alpha) throws WarpScriptException {
        GTSOutliersHelper.doubleCheck(gts);
        ArrayList anomalous_ticks = new ArrayList();
        throw new WarpScriptException("tietjenMooreTest: Work in Progress. Consider using ESDTest instead.");
    }

    public static List<Long> ESDTest(GeoTimeSerie gts, int k, boolean useMedian, double alpha) throws WarpScriptException {
        int N;
        int j;
        GTSOutliersHelper.doubleCheck(gts);
        GeoTimeSerie clone = new GeoTimeSerie();
        clone.type = gts.type;
        clone.values = gts.values;
        clone.doubleValues = Arrays.copyOf(gts.doubleValues, gts.values);
        clone.ticks = Arrays.copyOf(gts.ticks, gts.values);
        ArrayList<Long> anomalous_ticks = new ArrayList<Long>();
        int greater_j_test_passed = -1;
        for (j = 0; j < k && (N = clone.values) >= 3; ++j) {
            double[] musigma = GTSOutliersHelper.madsigma(clone, useMedian);
            double m = musigma[0];
            double std = musigma[1];
            if (0.0 == std) break;
            double z = 0.0;
            double max = Double.NEGATIVE_INFINITY;
            int suspicious_idx = 0;
            for (int i = 0; i < N; ++i) {
                z = Math.abs((clone.doubleValues[i] - m) / std);
                if (!(z > max)) continue;
                max = z;
                suspicious_idx = i;
            }
            double p = 1.0 - alpha / (double)(2 * N);
            double t = new TDistribution((double)(N - 2)).inverseCumulativeProbability(p);
            double lambda = (double)(N - 1) * t / Math.sqrt(((double)(N - 2) + t * t) * (double)N);
            if (max > lambda) {
                greater_j_test_passed = j;
            }
            --clone.values;
            long tmp_tick = clone.ticks[suspicious_idx];
            clone.ticks[suspicious_idx] = clone.ticks[clone.values];
            clone.ticks[clone.values] = tmp_tick;
            clone.doubleValues[suspicious_idx] = clone.doubleValues[clone.values];
        }
        for (j = 0; j <= greater_j_test_passed; ++j) {
            anomalous_ticks.add(clone.ticks[gts.values - 1 - j]);
        }
        return anomalous_ticks;
    }

    public static List<Long> ESDTest(GeoTimeSerie gts, int k, boolean useMedian) throws WarpScriptException {
        return GTSOutliersHelper.ESDTest(gts, k, useMedian, 0.05);
    }

    public static List<Long> STLESDTest(GeoTimeSerie gts, int buckets_per_period, int k, double alpha, Map<String, Object> params) throws WarpScriptException {
        GTSOutliersHelper.doubleCheck(gts);
        ArrayList<Long> anomalous_ticks = new ArrayList<Long>();
        if (!GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException("GTS must be bucketized");
        }
        if (null == params) {
            params = new HashMap<String, Object>();
        }
        if (null != params.get("PERIOD")) {
            if (buckets_per_period != (Integer)params.get("PERIOD")) {
                throw new WarpScriptException("Incoherence between PERIOD parameter of test and PERIOD parameter of STL");
            }
        } else {
            params.put("PERIOD", buckets_per_period);
        }
        if (null == params.get("BANDWIDTH_S")) {
            params.put("BANDWIDTH_S", -1);
        }
        if (null == params.get("ROBUST")) {
            params.put("ROBUST", false);
        }
        List stl_output = (List)new STL("STL").doGtsOp(params, gts);
        GeoTimeSerie seasonal = (GeoTimeSerie)stl_output.get(0);
        GeoTimeSerie trend = (GeoTimeSerie)stl_output.get(1);
        GeoTimeSerie remainder = seasonal;
        int idx = 0;
        for (int i = 0; i < gts.values; ++i) {
            if ((idx = Arrays.binarySearch(seasonal.ticks, idx, seasonal.values, gts.ticks[i])) < 0) {
                throw new WarpScriptException("Internal bug method STLESDTest");
            }
            remainder.doubleValues[i] = gts.doubleValues[idx] - (seasonal.doubleValues[idx] + trend.doubleValues[idx]);
        }
        remainder.values = gts.values;
        remainder.bucketcount = gts.bucketcount;
        remainder.bucketspan = gts.bucketspan;
        remainder.lastbucket = gts.lastbucket;
        anomalous_ticks.addAll(GTSOutliersHelper.ESDTest(remainder, k, true, alpha));
        return anomalous_ticks;
    }

    public static List<Long> entropyTest(GeoTimeSerie gts, int buckets_per_period) throws WarpScriptException {
        GTSOutliersHelper.doubleCheck(gts);
        ArrayList anomalous_ticks = new ArrayList();
        throw new WarpScriptException("entropyTest: Work In Progress. Consider using entropyHybridTest");
    }

    public static List<Long> hybridTest(GeoTimeSerie gts, int buckets_per_period, int periods_per_piece, int k, double alpha, Map<String, Object> params) throws WarpScriptException {
        GTSOutliersHelper.doubleCheck(gts);
        ArrayList<Long> anomalous_ticks = new ArrayList<Long>();
        if (!GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException("GTS must be bucketized");
        }
        if (k >= periods_per_piece * buckets_per_period / 2) {
            throw new WarpScriptException("Upper bound of number of outliers must be less than half of the number of observations per piece");
        }
        if (gts.bucketcount / buckets_per_period < 1) {
            throw new WarpScriptException("Not enough buckets to make up at least one seasonal period.");
        }
        GeoTimeSerie subgts = null;
        GeoTimeSerie seasonal = null;
        long pieces = gts.bucketcount / buckets_per_period / periods_per_piece;
        if (0L == pieces) {
            throw new WarpScriptException("Not enough seasonal periods to make up at least one piece. Please use a lower number of periods per piece.");
        }
        int bpp = periods_per_piece * buckets_per_period;
        long lb = gts.lastbucket;
        long bs = gts.bucketspan;
        if (null == params) {
            params = new HashMap<String, Object>();
        }
        if (null != params.get("PERIOD")) {
            if (buckets_per_period != (Integer)params.get("PERIOD")) {
                throw new WarpScriptException("Incoherence between PERIOD parameter of test and PERIOD parameter of STL");
            }
        } else {
            params.put("PERIOD", buckets_per_period);
        }
        if (null == params.get("BANDWIDTH_S")) {
            params.put("BANDWIDTH_S", -1);
        }
        if (null == params.get("ROBUST")) {
            params.put("ROBUST", false);
        }
        STL stl = new STL("STL");
        int u = 0;
        while ((long)u < pieces) {
            long start = lb - bs * ((pieces - (long)u) * (long)bpp - 1L);
            long stop = lb - bs * (pieces - (long)u - 1L) * (long)bpp;
            subgts = GTSHelper.subSerie(gts, start, stop, false, false, subgts);
            subgts.lastbucket = stop;
            subgts.bucketcount = bpp;
            subgts.bucketspan = bs;
            seasonal = (GeoTimeSerie)((List)stl.doGtsOp(params, subgts)).get(0);
            double m = GTSOutliersHelper.median(subgts);
            int idx = 0;
            int i = 0;
            while (i < subgts.values) {
                if ((idx = Arrays.binarySearch(seasonal.ticks, idx, seasonal.values, subgts.ticks[i])) < 0) {
                    throw new WarpScriptException("Internal bug method hybridTest: can't find tick " + subgts.ticks[i] + " in seasonal.ticks");
                }
                int n = i++;
                subgts.doubleValues[n] = subgts.doubleValues[n] - (seasonal.doubleValues[idx] + m);
            }
            anomalous_ticks.addAll(GTSOutliersHelper.ESDTest(subgts, k, true, alpha));
            ++u;
        }
        return anomalous_ticks;
    }

    public static List<Long> entropyHybridTest(GeoTimeSerie gts, int buckets_per_period, int periods_per_piece, int k, double alpha) throws WarpScriptException {
        GTSOutliersHelper.doubleCheck(gts);
        ArrayList<Long> anomalous_ticks = new ArrayList<Long>();
        if (!GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException("GTS must be bucketized");
        }
        if (k >= periods_per_piece * buckets_per_period / 2) {
            throw new WarpScriptException("Upper bound of number of outliers must be less than half of the number of observations per piece");
        }
        if (gts.bucketcount / buckets_per_period < 1) {
            throw new WarpScriptException("Not enough buckets to make up at least one seasonal period.");
        }
        GeoTimeSerie subgts = null;
        GeoTimeSerie subsubgts = null;
        GeoTimeSerie seasonal = null;
        long pieces = gts.bucketcount / buckets_per_period / periods_per_piece;
        if (0L == pieces) {
            throw new WarpScriptException("Not enough seasonal periods to make up at least one piece. Please use a lower number of periods per piece.");
        }
        int bpp = periods_per_piece * buckets_per_period;
        long lb = gts.lastbucket;
        long bs = gts.bucketspan;
        int u = 0;
        while ((long)u < pieces) {
            long start = lb - bs * ((pieces - (long)u) * (long)bpp - 1L);
            long stop = lb - bs * (pieces - (long)u - 1L) * (long)bpp;
            subgts = GTSHelper.subSerie(gts, start, stop, false, false, subgts);
            subgts.lastbucket = stop;
            subgts.bucketcount = bpp;
            subgts.bucketspan = bs;
            if (null == seasonal) {
                seasonal = new GeoTimeSerie(bpp);
                seasonal.doubleValues = new double[bpp];
                seasonal.ticks = new long[bpp];
            } else {
                GTSHelper.reset(seasonal);
            }
            seasonal.type = GeoTimeSerie.TYPE.DOUBLE;
            for (int v = 0; v < buckets_per_period; ++v) {
                int w;
                subsubgts = GTSHelper.subCycleSerie(subgts, stop - (long)v * bs, buckets_per_period, true, subsubgts);
                double[] musigma = GTSHelper.musigma(subsubgts, true);
                double mu = musigma[0];
                double sigma = musigma[1];
                double sum = 0.0;
                for (int w2 = 0; w2 < subsubgts.values; ++w2) {
                    subsubgts.doubleValues[w2] = 0.0 != sigma ? Math.abs((subsubgts.doubleValues[w2] - mu) / sigma) : 1.0;
                    subsubgts.doubleValues[w2] = Math.exp(Math.sqrt(subsubgts.doubleValues[w2]));
                    sum += subsubgts.doubleValues[w2];
                }
                double entropy = 0.0;
                for (w = 0; w < subsubgts.values; ++w) {
                    int n = w;
                    subsubgts.doubleValues[n] = subsubgts.doubleValues[n] / sum;
                    double tmp = subsubgts.doubleValues[w];
                    if (0.0 == tmp) continue;
                    entropy -= tmp * Math.log(tmp);
                }
                entropy = 0.0 != entropy ? (entropy /= Math.log(subsubgts.values)) : 1.0;
                for (w = 0; w < subsubgts.values; ++w) {
                    GTSHelper.setValue(seasonal, subsubgts.ticks[w], entropy * mu);
                }
            }
            GTSHelper.sort(seasonal);
            double m = GTSOutliersHelper.median(subgts);
            int idx = 0;
            int i = 0;
            while (i < subgts.values) {
                if ((idx = Arrays.binarySearch(seasonal.ticks, idx, seasonal.values, subgts.ticks[i])) < 0) {
                    throw new WarpScriptException("Internal bug method entropyHybridTest: can't find tick " + subgts.ticks[i] + " in seasonal.ticks");
                }
                int n = i++;
                subgts.doubleValues[n] = subgts.doubleValues[n] - (seasonal.doubleValues[idx] + m);
            }
            anomalous_ticks.addAll(GTSOutliersHelper.ESDTest(subgts, k, true, alpha));
            ++u;
        }
        return anomalous_ticks;
    }
}

