/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.WarpScriptException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GTSSplitter {
    public static List<GTSWrapper> chunk(GTSDecoder decoder, long clipfrom, long clipto, long tsboundary, long chunkwidth, String chunklabel, String fileprefix, long maxsize, long maxgts, float lwmratio) throws WarpScriptException, IOException {
        LinkedHashMap<Long, GTSEncoder> encoders = new LinkedHashMap<Long, GTSEncoder>();
        if (decoder.getLabels().containsKey(chunklabel)) {
            throw new WarpScriptException(chunklabel + " is already a label of the GTS to chunk.");
        }
        long totalsize = 0L;
        boolean spilled = false;
        long boundary = tsboundary % chunkwidth;
        while (decoder.next()) {
            if (decoder.getTimestamp() < clipfrom || decoder.getTimestamp() > clipto) continue;
            long chunk = chunkwidth * (decoder.getTimestamp() / chunkwidth) + boundary + (boundary >= decoder.getTimestamp() % chunkwidth ? 0L : chunkwidth);
            GTSEncoder encoder = (GTSEncoder)encoders.get(chunk);
            if (null == encoder) {
                encoder = new GTSEncoder(0L);
                encoder.setMetadata(decoder.getMetadata());
                encoder.getMetadata().putToLabels(chunklabel, Long.toString(chunk));
                encoders.put(chunk, encoder);
            }
            int encsize = encoder.size();
            encoder.addValue(decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue());
            if ((totalsize += (long)(encoder.size() - encsize)) <= maxsize && (long)encoders.size() <= maxgts) continue;
            int ngts = encoders.size();
            int emptyenc = 0;
            while ((float)ngts > lwmratio * (float)maxgts || (float)totalsize > lwmratio * (float)maxsize) {
                for (Map.Entry entry : encoders.entrySet()) {
                    Long l = (Long)entry.getKey();
                    GTSEncoder enc = (GTSEncoder)entry.getValue();
                    if (0 == enc.size()) {
                        ++emptyenc;
                        continue;
                    }
                    FileOutputStream out = new FileOutputStream(fileprefix + "-" + Long.toString(l), true);
                    out.write(enc.getBytes());
                    spilled = true;
                    out.close();
                    totalsize -= (long)enc.size();
                    enc.flush();
                    ++emptyenc;
                    if (!((float)totalsize <= lwmratio * (float)maxsize) || (long)ngts >= maxgts && !((float)(ngts - emptyenc) <= lwmratio * (float)maxgts)) continue;
                    break;
                }
                if ((long)ngts <= maxgts) continue;
                ArrayList<Long> toremove = new ArrayList<Long>();
                for (Map.Entry entry : encoders.entrySet()) {
                    Long chunkid = (Long)entry.getKey();
                    GTSEncoder enc = (GTSEncoder)entry.getValue();
                    if (0 == enc.size()) {
                        toremove.add(chunkid);
                        --ngts;
                    }
                    if (!((float)ngts <= lwmratio * (float)maxgts)) continue;
                    break;
                }
                Iterator iterator = toremove.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    encoders.remove(l);
                }
            }
        }
        long lastchunk = chunkwidth * (clipto / chunkwidth) + boundary + (boundary >= clipto % chunkwidth ? 0L : chunkwidth);
        long firstchunk = chunkwidth * (clipfrom / chunkwidth) + boundary + (boundary >= clipfrom % chunkwidth ? 0L : chunkwidth);
        if (spilled) {
            for (long chunkid = firstchunk; chunkid <= lastchunk; chunkid += chunkwidth) {
                GTSEncoder encoder = (GTSEncoder)encoders.get(chunkid);
                if (null == encoder) {
                    File file = new File(fileprefix + "-" + Long.toString(chunkid));
                    file.createNewFile();
                    continue;
                }
                if (0 == encoder.size()) continue;
                FileOutputStream fileOutputStream = new FileOutputStream(fileprefix + "-" + Long.toString(chunkid), true);
                fileOutputStream.write(encoder.getBytes());
                fileOutputStream.close();
            }
        }
        if (spilled) {
            return null;
        }
        ArrayList<GTSWrapper> result = new ArrayList<GTSWrapper>();
        for (long chunkid = firstchunk; chunkid <= lastchunk; chunkid += chunkwidth) {
            GTSWrapper gTSWrapper = new GTSWrapper();
            GTSEncoder gTSEncoder = (GTSEncoder)encoders.get(chunkid);
            gTSWrapper.setMetadata(new Metadata(decoder.getMetadata()));
            gTSWrapper.getMetadata().putToLabels(chunklabel, Long.toString(chunkid));
            gTSWrapper.setBase(0L);
            gTSWrapper.setBucketcount(1L);
            gTSWrapper.setBucketspan(chunkwidth);
            gTSWrapper.setLastbucket(chunkid);
            if (null != gTSEncoder) {
                gTSWrapper.setCount(gTSEncoder.getCount());
                gTSWrapper.setEncoded(gTSEncoder.getBytes());
            }
            result.add(gTSWrapper);
        }
        return result;
    }
}

