/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.continuum.store.thrift.data.Metadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GTSWrapperHelper {
    public static final double DEFAULT_COMP_RATIO_THRESHOLD = 100.0;

    public static GTSDecoder fromGTSWrapperToGTSDecoder(GTSWrapper wrapper) {
        byte[] unwrapped = GTSWrapperHelper.unwrapEncoded(wrapper);
        GTSDecoder decoder = new GTSDecoder(wrapper.getBase(), ByteBuffer.wrap(unwrapped).order(ByteOrder.BIG_ENDIAN));
        if (wrapper.isSetMetadata()) {
            decoder.setMetadata(wrapper.getMetadata());
        } else {
            decoder.safeSetMetadata(new Metadata());
        }
        decoder.setCount(wrapper.getCount());
        return decoder;
    }

    public static GTSEncoder fromGTSWrapperToGTSEncoder(GTSWrapper wrapper) throws IOException {
        if (wrapper.getEncoded().length > 0) {
            GTSDecoder decoder = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(wrapper);
            decoder.next();
            return decoder.getEncoder(true);
        }
        GTSEncoder encoder = new GTSEncoder(wrapper.getBase());
        if (wrapper.isSetMetadata()) {
            encoder.setMetadata(wrapper.getMetadata());
        } else {
            encoder.safeSetMetadata(new Metadata());
        }
        return encoder;
    }

    public static GeoTimeSerie fromGTSWrapperToGTS(GTSWrapper wrapper) {
        return GTSWrapperHelper.fromGTSWrapperToGTS(wrapper, false);
    }

    public static GeoTimeSerie fromGTSWrapperToGTS(GTSWrapper wrapper, boolean empty) {
        Metadata metadata = wrapper.getMetadata();
        GeoTimeSerie gts = null;
        if (null != wrapper.getEncoded() && !empty) {
            byte[] bytes = null;
            bytes = wrapper.isCompressed() ? GTSWrapperHelper.unwrapEncoded(wrapper) : wrapper.getEncoded();
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            GTSDecoder decoder = new GTSDecoder(wrapper.getBase(), bb);
            decoder.setCount(0L != wrapper.getCount() ? wrapper.getCount() : (long)(bytes.length / 10));
            gts = decoder.decode();
        } else {
            gts = new GeoTimeSerie();
        }
        if (null == metadata) {
            metadata = new Metadata();
        }
        if (wrapper.isSetBucketcount()) {
            gts.bucketcount = (int)wrapper.getBucketcount();
        }
        if (wrapper.isSetBucketspan()) {
            gts.bucketspan = wrapper.getBucketspan();
        }
        if (wrapper.isSetLastbucket()) {
            gts.lastbucket = wrapper.getLastbucket();
        }
        gts.setMetadata(metadata);
        return gts;
    }

    public static GTSWrapper fromGTSToGTSWrapper(GeoTimeSerie gts) {
        return GTSWrapperHelper.fromGTSToGTSWrapper(gts, false);
    }

    public static GTSWrapper fromGTSEncoderToGTSWrapper(GTSEncoder encoder, boolean compress) {
        return GTSWrapperHelper.fromGTSEncoderToGTSWrapper(encoder, compress, 100.0);
    }

    public static GTSWrapper fromGTSEncoderToGTSWrapper(GTSEncoder encoder, boolean compress, double compratio) {
        return GTSWrapperHelper.fromGTSEncoderToGTSWrapper(encoder, compress, compratio, Integer.MAX_VALUE);
    }

    public static GTSWrapper fromGTSEncoderToGTSWrapper(GTSEncoder encoder, boolean compress, double compratio, int maxpasses) {
        return GTSWrapperHelper.fromGTSEncoderToGTSWrapper(encoder, compress, compratio, maxpasses, true);
    }

    public static GTSWrapper fromGTSEncoderToGTSWrapper(GTSEncoder encoder, boolean compress, double compratio, int maxpasses, boolean setCount) {
        if (compratio < 1.0) {
            compratio = 1.0;
        }
        GTSWrapper wrapper = new GTSWrapper();
        try {
            Metadata meta;
            if (!compress || maxpasses <= 0) {
                wrapper.setEncoded(encoder.getBytes());
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = encoder.getBytes();
                double ratio = 0.0;
                int pass = 0;
                byte[] encoded = null;
                do {
                    encoded = bytes;
                    ratio = bytes.length;
                    GZIPOutputStream gzos = new GZIPOutputStream(baos);
                    gzos.write(bytes);
                    gzos.close();
                    bytes = baos.toByteArray();
                    baos.reset();
                } while (++pass < maxpasses && (ratio /= (double)bytes.length) > compratio);
                if (ratio > 1.0) {
                    wrapper.setEncoded(bytes);
                } else {
                    --pass;
                    wrapper.setEncoded(encoded);
                }
                if (pass > 0) {
                    wrapper.setCompressed(true);
                    if (pass > 1) {
                        wrapper.setCompressionPasses(pass);
                    }
                }
            }
            if (0L != encoder.getBaseTimestamp()) {
                wrapper.setBase(encoder.getBaseTimestamp());
            }
            if (setCount) {
                wrapper.setCount(encoder.getCount());
            }
            if (null != (meta = encoder.getMetadata()) && (meta.isSetName() && !"".equals(meta.getName()) || meta.isSetLabels() && meta.getLabelsSize() > 0 || meta.isSetAttributes() && meta.getAttributesSize() > 0 || meta.isSetClassId() || meta.isSetLabelsId() || meta.isSetSource() || meta.isSetLastActivity())) {
                wrapper.setMetadata(encoder.getMetadata());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wrapper;
    }

    public static GTSWrapper fromGTSToGTSWrapper(GeoTimeSerie gts, boolean compress) {
        return GTSWrapperHelper.fromGTSToGTSWrapper(gts, compress, 100.0);
    }

    public static GTSWrapper fromGTSToGTSWrapper(GeoTimeSerie gts, boolean compress, double compratio) {
        return GTSWrapperHelper.fromGTSToGTSWrapper(gts, compress, compratio, false);
    }

    public static GTSWrapper fromGTSToGTSWrapper(GeoTimeSerie gts, boolean compress, double compratio, boolean optimized) {
        return GTSWrapperHelper.fromGTSToGTSWrapper(gts, compress, compratio, Integer.MAX_VALUE, optimized, true);
    }

    public static GTSWrapper fromGTSToGTSWrapper(GeoTimeSerie gts, boolean compress, double compratio, int maxpasses, boolean optimized, boolean setCount) {
        GTSEncoder encoder = new GTSEncoder(0L);
        encoder.setMetadata(gts.getMetadata());
        try {
            if (optimized && GeoTimeSerie.TYPE.DOUBLE == gts.getType()) {
                encoder.encodeOptimized(gts);
            } else {
                encoder.encode(gts);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GTSWrapper wrapper = GTSWrapperHelper.fromGTSEncoderToGTSWrapper(encoder, compress, compratio, maxpasses, setCount);
        if (GTSHelper.isBucketized(gts)) {
            wrapper.setBucketcount(gts.bucketcount);
            wrapper.setBucketspan(gts.bucketspan);
            wrapper.setLastbucket(gts.lastbucket);
        }
        return wrapper;
    }

    public static GTSWrapper clip(GTSWrapper wrapper, long from, long to) {
        GTSEncoder encoder;
        GTSDecoder decoder = new GTSDecoder(wrapper.getBase(), ByteBuffer.wrap(GTSWrapperHelper.unwrapEncoded(wrapper)));
        GTSEncoder gTSEncoder = encoder = wrapper.isSetKey() ? new GTSEncoder(wrapper.getBase(), wrapper.getKey()) : new GTSEncoder(wrapper.getBase());
        while (decoder.next()) {
            if (decoder.getTimestamp() < from || decoder.getTimestamp() > to) continue;
            try {
                encoder.addValue(decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue());
            }
            catch (IOException ioe) {
                return null;
            }
        }
        GTSWrapper clipped = new GTSWrapper();
        clipped.setBase(wrapper.getBase());
        clipped.setBucketcount(wrapper.getBucketcount());
        clipped.setBucketspan(wrapper.getBucketspan());
        clipped.setCount(encoder.getCount());
        clipped.setEncoded(encoder.getBytes());
        clipped.setLastbucket(wrapper.getLastbucket());
        if (wrapper.isSetMetadata()) {
            clipped.setMetadata(new Metadata(wrapper.getMetadata()));
        }
        if (wrapper.isSetKey()) {
            clipped.setKey(wrapper.getKey());
        }
        return clipped;
    }

    private static byte[] unwrapEncoded(GTSWrapper wrapper) {
        if (!wrapper.isCompressed()) {
            return wrapper.getEncoded();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = wrapper.getEncoded();
        for (int pass = wrapper.getCompressionPasses(); pass > 0; --pass) {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            baos.reset();
            try {
                int len;
                GZIPInputStream gzis = new GZIPInputStream(in);
                byte[] buf = new byte[1024];
                while ((len = gzis.read(buf)) >= 0) {
                    baos.write(buf, 0, len);
                }
                gzis.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Invalid compressed content.");
            }
            bytes = baos.toByteArray();
        }
        return bytes;
    }

    public static boolean isBucketized(GTSWrapper gtsWrapper) {
        return 0L != gtsWrapper.getBucketcount() && 0L != gtsWrapper.getBucketspan() && 0L != gtsWrapper.getLastbucket();
    }

    public static byte[] getId(GTSWrapper wrapper) {
        byte[] id = new byte[16];
        if (!wrapper.isSetMetadata()) {
            return id;
        }
        long classId = wrapper.getMetadata().getClassId();
        long labelsId = wrapper.getMetadata().getLabelsId();
        for (int i = 7; i >= 0; --i) {
            id[i] = (byte)(classId & 0xFFL);
            classId >>>= 8;
            id[8 + i] = (byte)(labelsId & 0xFFL);
            labelsId >>>= 8;
        }
        return id;
    }

    public static GTSWrapper rewrap(GTSWrapper wrapper, boolean compress, double compratio) {
        byte[] unwrapped = GTSWrapperHelper.unwrapEncoded(wrapper);
        GTSEncoder encoder = new GTSEncoder(wrapper.getBase(), null, unwrapped);
        GTSWrapper tmp = GTSWrapperHelper.fromGTSEncoderToGTSWrapper(encoder, compress, compratio);
        GTSWrapper rewrapped = new GTSWrapper(wrapper);
        rewrapped.setCompressed(tmp.isCompressed());
        rewrapped.setCompressionPasses(tmp.getCompressionPasses());
        rewrapped.setEncoded(tmp.getEncoded());
        return rewrapped;
    }
}

