/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.store.thrift.data.Metadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MetadataTextComparator
implements Comparator<Metadata> {
    private final List<String> fields;

    public MetadataTextComparator(List<String> fields) {
        this.fields = fields;
    }

    @Override
    public int compare(Metadata o1, Metadata o2) {
        int idx2;
        if (null != this.fields && !this.fields.isEmpty()) {
            return this.compareWithFields(o1, o2);
        }
        if (null == o1) {
            return -1;
        }
        if (null == o2) {
            return 1;
        }
        String name1 = o1.getName();
        String name2 = o2.getName();
        if (null == name1) {
            return -1;
        }
        if (null == name2) {
            return 1;
        }
        int comp = name1.compareTo(name2);
        if (0 != comp) {
            return comp;
        }
        if (0 == o1.getLabelsSize() && 0 == o2.getLabelsSize()) {
            return 0;
        }
        if (0 == o1.getLabelsSize()) {
            return -1;
        }
        if (0 == o2.getLabelsSize()) {
            return 1;
        }
        ArrayList<String> labels1 = new ArrayList<String>(o1.getLabelsSize());
        labels1.addAll(o1.getLabels().keySet());
        ArrayList<String> labels2 = new ArrayList<String>(o2.getLabelsSize());
        labels2.addAll(o2.getLabels().keySet());
        Collections.sort(labels1);
        Collections.sort(labels2);
        int idx1 = 0;
        for (idx2 = 0; idx1 < labels1.size() && idx2 < labels2.size(); ++idx1, ++idx2) {
            comp = ((String)labels1.get(idx1)).compareTo((String)labels2.get(idx2));
            if (0 != comp) {
                return comp;
            }
            comp = o1.getLabels().get(labels1.get(idx1)).compareTo(o2.getLabels().get(labels2.get(idx2)));
            if (0 == comp) continue;
            return comp;
        }
        if (idx1 == idx2) {
            return 0;
        }
        if (idx1 < idx2) {
            return -1;
        }
        return 1;
    }

    private int compareWithFields(Metadata o1, Metadata o2) {
        for (String field : this.fields) {
            int comp;
            String s1 = null;
            String s2 = null;
            if (null == field) {
                s1 = o1.getName();
                s2 = o2.getName();
            } else {
                if (o1.getLabelsSize() > 0) {
                    s1 = o1.getLabels().get(field);
                }
                if (o2.getLabelsSize() > 0) {
                    s2 = o2.getLabels().get(field);
                }
            }
            if (null == s1 && null != s2) {
                return -1;
            }
            if (null == s2 && null != s1) {
                return 1;
            }
            if (null == s1 && null == s2 || 0 == (comp = s1.compareTo(s2))) continue;
            return comp;
        }
        return 0;
    }
}

