/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import com.google.common.base.Preconditions;
import io.warp10.continuum.gts.CustomBuffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class Varint {
    public static byte[] encodeUnsignedLongBRANCHMISPREDICT(long value) {
        byte[] buf = null;
        buf = 0L != (value & Long.MIN_VALUE) ? new byte[10] : (0L != (value & 0xFF00000000000000L) ? new byte[9] : (0L != (value & 0xFFFE000000000000L) ? new byte[8] : (0L != (value & 0xFFFFFC0000000000L) ? new byte[7] : (0L != (value & 0xFFFFFFF800000000L) ? new byte[6] : (0L != (value & 0xFFFFFFFFF0000000L) ? new byte[5] : (0L != (value & 0xFFFFFFFFFFE00000L) ? new byte[4] : (0L != (value & 0xFFFFFFFFFFFFC000L) ? new byte[3] : (0L != (value & 0xFFFFFFFFFFFFFF80L) ? new byte[2] : new byte[1]))))))));
        int count = 0;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            int n = count;
            count = (byte)(count + 1);
            buf[n] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        buf[count] = (byte)(value & 0x7FL);
        return buf;
    }

    public static byte[] encodeUnsignedLong_ORIGINAL(long value) {
        byte[] buf = new byte[10];
        int count = 0;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buf[count++] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        buf[count++] = (byte)(value & 0x7FL);
        if (count < 10) {
            return Arrays.copyOf(buf, count);
        }
        return buf;
    }

    public static byte[] encodeUnsignedLong(long value) {
        if (0L == (value & 0xFFFFFFFFFFFFFF80L)) {
            byte[] buf = new byte[]{(byte)(value & 0x7FL)};
            return buf;
        }
        byte b0 = (byte)((int)value & 0x7F | 0x80);
        if (0L == ((value >>>= 7) & 0xFFFFFFFFFFFFFF80L)) {
            byte[] buf = new byte[]{b0, (byte)(value & 0x7FL)};
            return buf;
        }
        byte b1 = (byte)((int)value & 0x7F | 0x80);
        if (0L == ((value >>>= 7) & 0xFFFFFFFFFFFFFF80L)) {
            byte[] buf = new byte[]{b0, b1, (byte)(value & 0x7FL)};
            return buf;
        }
        byte b2 = (byte)((int)value & 0x7F | 0x80);
        if (0L == ((value >>>= 7) & 0xFFFFFFFFFFFFFF80L)) {
            byte[] buf = new byte[]{b0, b1, b2, (byte)(value & 0x7FL)};
            return buf;
        }
        byte b3 = (byte)((int)value & 0x7F | 0x80);
        if (0L == ((value >>>= 7) & 0xFFFFFFFFFFFFFF80L)) {
            byte[] buf = new byte[]{b0, b1, b2, b3, (byte)(value & 0x7FL)};
            return buf;
        }
        byte b4 = (byte)((int)value & 0x7F | 0x80);
        if (0L == ((value >>>= 7) & 0xFFFFFFFFFFFFFF80L)) {
            byte[] buf = new byte[]{b0, b1, b2, b3, b4, (byte)(value & 0x7FL)};
            return buf;
        }
        byte b5 = (byte)((int)value & 0x7F | 0x80);
        if (0L == ((value >>>= 7) & 0xFFFFFFFFFFFFFF80L)) {
            byte[] buf = new byte[]{b0, b1, b2, b3, b4, b5, (byte)(value & 0x7FL)};
            return buf;
        }
        byte b6 = (byte)((int)value & 0x7F | 0x80);
        if (0L == ((value >>>= 7) & 0xFFFFFFFFFFFFFF80L)) {
            byte[] buf = new byte[]{b0, b1, b2, b3, b4, b5, b6, (byte)(value & 0x7FL)};
            return buf;
        }
        byte b7 = (byte)((int)value & 0x7F | 0x80);
        if (0L == ((value >>>= 7) & 0xFFFFFFFFFFFFFF80L)) {
            byte[] buf = new byte[]{b0, b1, b2, b3, b4, b5, b6, b7, (byte)(value & 0x7FL)};
            return buf;
        }
        byte b8 = (byte)((int)value & 0x7F | 0x80);
        byte[] buf = new byte[]{b0, b1, b2, b3, b4, b5, b6, b7, b8, (byte)((value >>>= 7) & 0x7FL)};
        return buf;
    }

    public static int encodeUnsignedLongInBuf(long value, byte[] buf) {
        int idx = 0;
        while (0L != (value & 0xFFFFFFFFFFFFFF80L)) {
            buf[idx++] = (byte)(value & 0x7FL | 0x80L);
            value >>>= 7;
        }
        buf[idx++] = (byte)(value & 0x7FL);
        return idx;
    }

    public static int encodeSignedLongInBuf(long value, byte[] buf) {
        value = value << 1 ^ value >> 63;
        return Varint.encodeUnsignedLongInBuf(value, buf);
    }

    public static byte[] encodeSignedLong(long value) {
        value = value << 1 ^ value >> 63;
        return Varint.encodeUnsignedLong(value);
    }

    public static long decodeUnsignedLong(byte[] buf) {
        long bytevalue;
        long value = 0L;
        int i = 0;
        int index = 0;
        while (((bytevalue = (long)buf[index++]) & 0x80L) != 0L) {
            value |= (bytevalue & 0x7FL) << i;
            Preconditions.checkArgument(((i += 7) <= 63 ? 1 : 0) != 0, (Object)"Variable length quantity is too long");
        }
        return value | bytevalue << i;
    }

    public static long decodeSignedLong(byte[] buf) {
        long unsigned = Varint.decodeUnsignedLong(buf);
        long signed = (unsigned << 63 >> 63 ^ unsigned) >> 1;
        return signed ^ unsigned & Long.MIN_VALUE;
    }

    public static long decodeUnsignedLong(ByteBuffer buffer) {
        long bytevalue;
        long value = 0L;
        int i = 0;
        while (((bytevalue = (long)buffer.get()) & 0x80L) != 0L) {
            value |= (bytevalue & 0x7FL) << i;
            Preconditions.checkArgument(((i += 7) <= 63 ? 1 : 0) != 0, (Object)"Variable length quantity is too long");
        }
        return value | bytevalue << i;
    }

    public static long decodeSignedLong(ByteBuffer buffer) {
        long unsigned = Varint.decodeUnsignedLong(buffer);
        long signed = (unsigned << 63 >> 63 ^ unsigned) >> 1;
        return signed ^ unsigned & Long.MIN_VALUE;
    }

    public static int skipVarint(ByteBuffer buffer) {
        long bytevalue;
        int skipped = 1;
        while (((bytevalue = (long)buffer.get()) & 0x80L) != 0L) {
            Preconditions.checkArgument((++skipped <= 9 ? 1 : 0) != 0, (Object)"Variable length quantity is too long");
        }
        return skipped;
    }

    public static long decodeUnsignedLong(CustomBuffer buffer) {
        long bytevalue;
        long value = 0L;
        int i = 0;
        while (((bytevalue = (long)buffer.get()) & 0x80L) != 0L) {
            value |= (bytevalue & 0x7FL) << i;
            Preconditions.checkArgument(((i += 7) <= 63 ? 1 : 0) != 0, (Object)"Variable length quantity is too long");
        }
        return value | bytevalue << i;
    }

    public static long decodeSignedLong(CustomBuffer buffer) {
        long unsigned = Varint.decodeUnsignedLong(buffer);
        long signed = (unsigned << 63 >> 63 ^ unsigned) >> 1;
        return signed ^ unsigned & Long.MIN_VALUE;
    }
}

