/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.crypto;

import com.google.common.primitives.Longs;
import io.warp10.crypto.SipHashInline;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.KeyParameter;

public class CryptoUtils {
    public static byte[] wrap(byte[] key, byte[] data) {
        AESWrapEngine engine = new AESWrapEngine();
        KeyParameter params = new KeyParameter(key);
        engine.init(true, (CipherParameters)params);
        PKCS7Padding padding = new PKCS7Padding();
        byte[] unpadded = data;
        byte[] padded = new byte[unpadded.length + (8 - unpadded.length % 8)];
        System.arraycopy(unpadded, 0, padded, 0, unpadded.length);
        padding.addPadding(padded, unpadded.length);
        byte[] encrypted = engine.wrap(padded, 0, padded.length);
        return encrypted;
    }

    public static byte[] unwrap(byte[] key, byte[] data) {
        AESWrapEngine engine = new AESWrapEngine();
        KeyParameter params = new KeyParameter(key);
        engine.init(false, (CipherParameters)params);
        try {
            byte[] decrypted = engine.unwrap(data, 0, data.length);
            PKCS7Padding padding = new PKCS7Padding();
            int padcount = padding.padCount(decrypted);
            decrypted = Arrays.copyOfRange(decrypted, 0, decrypted.length - padcount);
            return decrypted;
        }
        catch (InvalidCipherTextException icte) {
            return null;
        }
    }

    public static byte[] addMAC(long[] key, byte[] data) {
        long hash = SipHashInline.hash24_palindromic(key[0], key[1], data);
        byte[] authenticated = Arrays.copyOf(data, data.length + 8);
        System.arraycopy(Longs.toByteArray((long)hash), 0, authenticated, data.length, 8);
        return authenticated;
    }

    public static byte[] addMAC(byte[] key, byte[] data) {
        long hash = SipHashInline.hash24_palindromic(key, data);
        byte[] authenticated = Arrays.copyOf(data, data.length + 8);
        System.arraycopy(Longs.toByteArray((long)hash), 0, authenticated, data.length, 8);
        return authenticated;
    }

    public static byte[] removeMAC(byte[] key, byte[] data) {
        long hash = SipHashInline.hash24_palindromic(key, data, 0, data.length - 8);
        long mac = Longs.fromByteArray((byte[])Arrays.copyOfRange(data, data.length - 8, data.length));
        if (mac == hash) {
            return Arrays.copyOf(data, data.length - 8);
        }
        return null;
    }

    public static byte[] removeMAC(long[] key, byte[] data) {
        long hash = SipHashInline.hash24_palindromic(key[0], key[1], data, 0, data.length - 8);
        long mac = Longs.fromByteArray((byte[])Arrays.copyOfRange(data, data.length - 8, data.length));
        if (mac == hash) {
            return Arrays.copyOf(data, data.length - 8);
        }
        return null;
    }

    public static long safeSipHash(long k0, long k1, byte[] msg) {
        byte[] a = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(a).order(ByteOrder.BIG_ENDIAN);
        bb.putLong(SipHashInline.hash24(k0, k1, msg, 0, msg.length));
        bb.putLong(SipHashInline.hash24(k0, k1, msg, 0, msg.length, true));
        return SipHashInline.hash24(k0, k1, a, 0, a.length, false);
    }

    public static byte[] invert(byte[] key) {
        byte[] inverted = Arrays.copyOf(key, key.length);
        for (int i = 0; i < inverted.length; ++i) {
            inverted[i] = (byte)(inverted[i] & 0xFF);
        }
        return inverted;
    }
}

