/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;

public class Warp10InputSplit
extends InputSplit
implements Writable {
    private String[] fetchers;
    private byte[] splits;
    private boolean complete = false;
    private Set<String> fetcherSet = new LinkedHashSet<String>();
    private ByteArrayOutputStream baos = null;
    private OutputStream out = null;

    public void addEntry(String fetcher, String entry) throws IOException {
        if (this.complete) {
            throw new RuntimeException("InputSplit already completed.");
        }
        if (null != fetcher) {
            this.fetcherSet.add(fetcher);
        }
        if (null == this.out) {
            this.baos = new ByteArrayOutputStream();
            this.out = new GZIPOutputStream(this.baos);
        }
        this.out.write(entry.getBytes(StandardCharsets.US_ASCII));
        this.out.write(13);
        this.out.write(10);
    }

    public void addFetcher(String fetcher) {
        if (this.complete) {
            throw new RuntimeException("InputSplit already completed.");
        }
        this.fetcherSet.add(fetcher);
    }

    public Warp10InputSplit build() throws IOException {
        if (this.complete) {
            throw new RuntimeException("InputSplit already completed.");
        }
        this.out.close();
        this.splits = this.baos.toByteArray();
        this.baos.close();
        this.baos = null;
        this.fetchers = this.fetcherSet.toArray(new String[0]);
        this.complete = true;
        return this;
    }

    public long getLength() throws IOException {
        return 0L;
    }

    public String[] getLocations() throws IOException {
        return Arrays.copyOf(this.fetchers, this.fetchers.length);
    }

    public void readFields(DataInput in) throws IOException {
        int nfetchers = WritableUtils.readVInt((DataInput)in);
        this.fetchers = new String[nfetchers];
        for (int i = 0; i < nfetchers; ++i) {
            String currentFetcher;
            this.fetchers[i] = currentFetcher = WritableUtils.readString((DataInput)in);
        }
        int splitsize = WritableUtils.readVInt((DataInput)in);
        this.splits = WritableUtils.readCompressedByteArray((DataInput)in);
        this.complete = true;
    }

    public void write(DataOutput out) throws IOException {
        if (!this.complete) {
            throw new IOException("InputSplit is not completed.");
        }
        WritableUtils.writeVInt((DataOutput)out, (int)this.fetchers.length);
        for (int i = 0; i < this.fetchers.length; ++i) {
            WritableUtils.writeString((DataOutput)out, (String)this.fetchers[i]);
        }
        WritableUtils.writeVInt((DataOutput)out, (int)this.splits.length);
        WritableUtils.writeCompressedByteArray((DataOutput)out, (byte[])this.splits);
    }

    public byte[] getBytes() {
        return this.splits;
    }
}

