/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.hadoop;

import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.hadoop.Warp10InputSplit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Warp10RecordReader
extends RecordReader<Text, BytesWritable>
implements Progressable {
    private BufferedReader br = null;
    private HttpURLConnection conn = null;
    private Text key;
    private BytesWritable value;
    private long count = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(Warp10RecordReader.class);
    private Progressable progress = null;
    private final String suffix;

    public Warp10RecordReader() {
        this.suffix = "";
    }

    public Warp10RecordReader(String suffix) {
        this.suffix = suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (!(split instanceof Warp10InputSplit)) {
            throw new IOException("Invalid split type.");
        }
        this.progress = context;
        long now = Long.valueOf(this.getProperty((JobContext)context, "warp10.fetch.now"));
        long timespan = Long.valueOf(this.getProperty((JobContext)context, "warp10.fetch.timespan"));
        int connectTimeout = Integer.valueOf(this.getProperty((JobContext)context, "warp10.http.connect.timeout", "10000"));
        int readTimeout = Integer.valueOf(this.getProperty((JobContext)context, "warp10.http.read.timeout", "10000"));
        String protocol = this.getProperty((JobContext)context, "warp10.fetcher.protocol", "http");
        String port = this.getProperty((JobContext)context, "warp10.fetcher.port", "8881");
        String path = this.getProperty((JobContext)context, "warp10.fetcher.path", "/api/v0/sfetch");
        String nowHeader = this.getProperty((JobContext)context, "http.header.now", "X-Warp10-Now");
        String timespanHeader = this.getProperty((JobContext)context, "http.header.timespan", "X-Warp10-Timespan");
        for (String fetcher : split.getLocations()) {
            try {
                StringBuilder endpointSb = new StringBuilder();
                endpointSb.append(protocol);
                endpointSb.append("://");
                endpointSb.append(fetcher);
                endpointSb.append(":");
                endpointSb.append(port);
                StringBuilder sb = new StringBuilder();
                sb.append(endpointSb.toString());
                sb.append(path);
                URL url = new URL(sb.toString());
                LOG.info("Fetcher: " + endpointSb.toString());
                this.conn = (HttpURLConnection)url.openConnection();
                this.conn.setConnectTimeout(connectTimeout);
                this.conn.setReadTimeout(readTimeout);
                this.conn.setChunkedStreamingMode(16384);
                this.conn.setDoInput(true);
                this.conn.setDoOutput(true);
                this.conn.setRequestProperty(nowHeader, Long.toString(now));
                this.conn.setRequestProperty(timespanHeader, Long.toString(timespan));
                this.conn.setRequestProperty("Content-Type", "application/gzip");
                this.conn.connect();
                OutputStream out = this.conn.getOutputStream();
                out.write(((Warp10InputSplit)split).getBytes());
                if (200 != this.conn.getResponseCode()) {
                    System.err.println(url + " failed - error code: " + this.conn.getResponseCode());
                    InputStream is = this.conn.getErrorStream();
                    BufferedReader errorReader = new BufferedReader(new InputStreamReader(is));
                    String line = errorReader.readLine();
                    while (null != line) {
                        System.err.println(line);
                        line = errorReader.readLine();
                    }
                    is.close();
                    continue;
                }
                this.br = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (null == this.br && null != this.conn) {
                    try {
                        this.conn.disconnect();
                    }
                    catch (Exception exception) {}
                    this.conn = null;
                }
            }
        }
    }

    public boolean nextKeyValue() throws IOException {
        if (null == this.br) {
            return false;
        }
        String line = this.br.readLine();
        if (null == line) {
            return false;
        }
        if (line.startsWith("# ERROR: ")) {
            throw new IOException("Fetcher reported an error, aborting: " + line);
        }
        String[] tokens = line.split("\\s+");
        if (null == this.key) {
            this.key = new Text();
        }
        this.key.set(tokens[0]);
        if (null == this.value) {
            this.value = new BytesWritable();
        }
        byte[] wrapper = OrderPreservingBase64.decode(tokens[2].getBytes(StandardCharsets.US_ASCII));
        this.value.setCapacity(wrapper.length);
        this.value.set(wrapper, 0, wrapper.length);
        ++this.count;
        return true;
    }

    public void close() throws IOException {
        if (null != this.br) {
            this.br.close();
        }
        if (null != this.conn) {
            this.conn.disconnect();
        }
    }

    public Text getCurrentKey() {
        return this.key;
    }

    public BytesWritable getCurrentValue() {
        return this.value;
    }

    public float getProgress() throws IOException {
        return -1.0f;
    }

    public void progress() {
        if (null != this.progress) {
            this.progress.progress();
        }
    }

    private String getProperty(JobContext context, String property) {
        return this.getProperty(context, property, null);
    }

    private String getProperty(JobContext context, String property, String defaultValue) {
        if (null != context.getConfiguration().get(property + this.suffix)) {
            return context.getConfiguration().get(property + this.suffix);
        }
        if (null != context.getConfiguration().get(property)) {
            return context.getConfiguration().get(property);
        }
        if (null != defaultValue) {
            return defaultValue;
        }
        return null;
    }
}

