/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import com.geoxp.oss.CryptoHelper;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.netflix.curator.RetryPolicy;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.CuratorFrameworkFactory;
import com.netflix.curator.framework.recipes.leader.LeaderLatch;
import com.netflix.curator.retry.RetryNTimes;
import io.warp10.WarpConfig;
import io.warp10.WarpDist;
import io.warp10.continuum.KafkaProducerPool;
import io.warp10.continuum.KafkaSynchronizedConsumerPool;
import io.warp10.continuum.TimeSource;
import io.warp10.continuum.thrift.data.RunRequest;
import io.warp10.crypto.CryptoUtils;
import io.warp10.crypto.DummyKeyStore;
import io.warp10.crypto.KeyStore;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.crypto.SipHashInline;
import io.warp10.script.ScriptRunnerConsumerFactory;
import io.warp10.sensision.Sensision;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ScriptRunner
extends Thread {
    protected static final byte[] CLEAR = "\nCLEAR\n".getBytes(StandardCharsets.UTF_8);
    protected ExecutorService executor;
    protected long scanperiod;
    private String root;
    protected String endpoint;
    private long minperiod;
    private LeaderLatch leaderLatch;
    private KafkaProducerPool kafkaProducerPool;
    private String topic = null;
    private final String id;
    protected byte[] KAFKA_AES = null;
    protected long[] KAFKA_MAC = null;
    private KafkaSynchronizedConsumerPool consumerPool = null;
    public static final String[] REQUIRED_PROPERTIES_STANDALONE = new String[]{"runner.endpoint", "runner.nthreads", "runner.root", "runner.scanperiod", "runner.minperiod", "runner.id"};
    public static final String[] REQUIRED_PROPERTIES_WORKER = new String[]{"runner.kafka.zkconnect", "runner.kafka.topic", "runner.kafka.groupid", "runner.kafka.commitperiod", "runner.kafka.nthreads", "runner.nthreads", "runner.endpoint", "runner.id"};
    public static final String[] REQUIRED_PROPERTIES_SCHEDULER = new String[]{"runner.kafka.brokerlist", "runner.kafka.topic", "runner.kafka.poolsize", "runner.root", "runner.scanperiod", "runner.minperiod", "runner.id", "runner.zk.quorum", "runner.zk.znode"};
    private final boolean isScheduler;
    private final boolean isStandalone;
    private final boolean isWorker;
    private final KeyStore keystore;
    private final byte[] runnerPSK;
    private final boolean runAtStartup;
    private static final Pattern VAR = Pattern.compile("\\$\\{([^}]+)\\}");

    public ScriptRunner(KeyStore keystore, Properties config) throws IOException {
        Preconditions.checkNotNull((Object)config.getProperty("runner.roles"), (Object)"Property 'runner.roles' MUST be set.");
        String[] roles = config.getProperty("runner.roles").split(",");
        if (roles.length > 2) {
            throw new IOException("Role can only be 'standalone' or either or both 'scheduler' and 'worker'.");
        }
        HashSet<String> configuredRoles = new HashSet<String>();
        configuredRoles.addAll(Arrays.asList(roles));
        this.isStandalone = configuredRoles.contains("standalone");
        this.isScheduler = configuredRoles.contains("scheduler");
        this.isWorker = configuredRoles.contains("worker");
        this.runAtStartup = this.isStandalone || this.isScheduler ? "true".equals(config.getProperty("runner.runatstartup", "true")) : true;
        if (this.isStandalone && (this.isWorker || this.isScheduler)) {
            throw new IOException("Role is either 'standalone' or either or both 'scheduler' and 'worker'.");
        }
        this.keystore = keystore;
        this.runnerPSK = keystore.getKey("warp.aes.runner.psk");
        if (this.isStandalone) {
            String[] stringArray = REQUIRED_PROPERTIES_STANDALONE;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String required = stringArray[i];
                Preconditions.checkNotNull((Object)config.getProperty(required), (String)"Missing configuration parameter '%s'.", (Object[])new Object[]{required});
            }
            this.root = config.getProperty("runner.root");
            int nthreads = Integer.parseInt(config.getProperty("runner.nthreads"));
            this.scanperiod = Long.parseLong(config.getProperty("runner.scanperiod"));
            this.minperiod = Long.parseLong(config.getProperty("runner.minperiod"));
            this.endpoint = config.getProperty("runner.endpoint");
            ThreadPoolExecutor runnersExecutor = new ThreadPoolExecutor(nthreads, nthreads, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nthreads * 256), new NamedThreadFactory());
            runnersExecutor.allowCoreThreadTimeOut(true);
            this.executor = runnersExecutor;
            this.leaderLatch = null;
            this.setDaemon(true);
            this.setName("[Warp ScriptRunner]");
            this.start();
        }
        if (this.isWorker || this.isScheduler) {
            this.extractKeys(config);
            byte[] k = this.keystore.getKey("warp.siphash.kafka.runner");
            if (null != k) {
                this.KAFKA_MAC = SipHashInline.getKey(k);
            }
        }
        if (this.isWorker) {
            for (String required : REQUIRED_PROPERTIES_WORKER) {
                Preconditions.checkNotNull((Object)config.getProperty(required), (String)"Missing configuration parameter '%s'.", (Object[])new Object[]{required});
            }
            this.endpoint = config.getProperty("runner.endpoint");
            String zkconnect = config.getProperty("runner.kafka.zkconnect");
            this.topic = config.getProperty("runner.kafka.topic");
            String groupid = config.getProperty("runner.kafka.groupid");
            String clientid = config.getProperty("runner.kafka.consumer.clientid");
            String strategy = config.getProperty("runner.kafka.consumer.partition.assignment.strategy");
            int nthreads = Integer.parseInt(config.getProperty("runner.kafka.nthreads"));
            long commitPeriod = Long.parseLong(config.getProperty("runner.kafka.commitperiod"));
            ThreadPoolExecutor runnersExecutor = new ThreadPoolExecutor(nthreads, nthreads, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nthreads * 256), new NamedThreadFactory());
            runnersExecutor.allowCoreThreadTimeOut(true);
            this.executor = runnersExecutor;
            this.consumerPool = new KafkaSynchronizedConsumerPool(zkconnect, this.topic, clientid, groupid, strategy, nthreads, commitPeriod, (KafkaSynchronizedConsumerPool.ConsumerFactory)new ScriptRunnerConsumerFactory(this));
        }
        if (this.isScheduler) {
            for (String required : REQUIRED_PROPERTIES_SCHEDULER) {
                Preconditions.checkNotNull((Object)config.getProperty(required), (String)"Missing configuration parameter '%s'.", (Object[])new Object[]{required});
            }
            this.root = config.getProperty("runner.root");
            this.scanperiod = Long.parseLong(config.getProperty("runner.scanperiod"));
            this.minperiod = Long.parseLong(config.getProperty("runner.minperiod"));
            this.topic = config.getProperty("runner.kafka.topic");
            Properties props = new Properties();
            props.setProperty("metadata.broker.list", props.getProperty("runner.kafka.brokerlist"));
            if (null != props.getProperty("runner.kafka.producer.clientid")) {
                props.setProperty("client.id", props.getProperty("runner.kafka.producer.clientid"));
            }
            props.setProperty("request.required.acks", "-1");
            props.setProperty("producer.type", "sync");
            props.setProperty("serializer.class", "kafka.serializer.DefaultEncoder");
            ProducerConfig kafkaConfig = new ProducerConfig(props);
            this.kafkaProducerPool = new KafkaProducerPool(kafkaConfig, Integer.parseInt(props.getProperty("runner.kafka.poolsize")), "warp.runner.kafka.producer.pool.get", "warp.runner.kafka.producer.wait.nanos");
            CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectionTimeoutMs(1000).retryPolicy((RetryPolicy)new RetryNTimes(10, 500)).connectString(config.getProperty("runner.zk.quorum")).build();
            curatorFramework.start();
            this.leaderLatch = new LeaderLatch(curatorFramework, config.getProperty("runner.zk.znode"));
            try {
                this.leaderLatch.start();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.id = config.getProperty("runner.id");
    }

    @Override
    public void run() {
        long lastscan = System.currentTimeMillis() - 2L * this.scanperiod;
        HashMap scripts = new HashMap();
        final ConcurrentHashMap<String, Long> nextrun = new ConcurrentHashMap<String, Long>();
        PriorityQueue<String> runnables = new PriorityQueue<String>(1, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                long nextrun1 = null != nextrun.get(o1) ? (Long)nextrun.get(o1) : Long.MAX_VALUE;
                long nextrun2 = null != nextrun.get(o2) ? (Long)nextrun.get(o2) : Long.MAX_VALUE;
                return Long.compare(nextrun1, nextrun2);
            }
        });
        while (!WarpDist.isInitialized()) {
            LockSupport.parkNanos(100000000L);
        }
        while (true) {
            boolean isLeader;
            long now;
            if ((now = System.currentTimeMillis()) - lastscan > this.scanperiod) {
                Map<String, Long> newscripts = this.scanSuperRoot(this.root);
                Set set = scripts.keySet();
                scripts.clear();
                scripts.putAll(newscripts);
                for (String prevscript : set) {
                    if (scripts.containsKey(prevscript)) continue;
                    nextrun.remove(prevscript);
                }
                lastscan = now;
            }
            runnables.clear();
            for (Map.Entry entry : scripts.entrySet()) {
                String script = (String)entry.getKey();
                Long schedule = (Long)nextrun.get(script);
                if (null == schedule) {
                    if (this.runAtStartup) {
                        runnables.add(script);
                        continue;
                    }
                    Long period = (Long)entry.getValue();
                    long schedat = System.currentTimeMillis();
                    if (0L != schedat % period) {
                        schedat = schedat - schedat % period + period;
                    }
                    nextrun.put(script, schedat);
                    continue;
                }
                if (-1L == schedule || schedule > now) continue;
                runnables.add(script);
            }
            boolean bl = isLeader = this.isScheduler && this.leaderLatch.hasLeadership();
            while (runnables.size() > 0) {
                String string = runnables.poll();
                nextrun.put(string, -1L);
                if (this.isStandalone) {
                    this.schedule(nextrun, string, (Long)scripts.get(string));
                    continue;
                }
                if (!isLeader) continue;
                this.distributedSchedule(nextrun, string, (Long)scripts.get(string));
            }
            LockSupport.parkNanos(10000000L);
        }
    }

    protected void schedule(final Map<String, Long> nextrun, final String script, final long periodicity) {
        if (!this.isStandalone) {
            return;
        }
        final ScriptRunner self = this;
        try {
            final long scheduledat = System.currentTimeMillis();
            this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long nowts = System.currentTimeMillis();
                    Sensision.update((String)"warp.script.run.current", (Map)Sensision.EMPTY_LABELS, (Number)1);
                    File f = new File(script);
                    String path = new File(script).getAbsolutePath().substring(new File(self.root).getAbsolutePath().length() + 1);
                    HashMap<String, String> labels = new HashMap<String, String>();
                    labels.put("path", path);
                    Sensision.update((String)"warp.script.run.count", labels, (Number)1);
                    long nano = System.nanoTime();
                    HttpURLConnection conn = null;
                    long ttl = Math.max(ScriptRunner.this.scanperiod * 2L, periodicity * 2L);
                    FileInputStream in = null;
                    try {
                        String line;
                        in = new FileInputStream(f);
                        conn = (HttpURLConnection)new URL(self.endpoint).openConnection();
                        conn.setDoOutput(true);
                        conn.setChunkedStreamingMode(8192);
                        conn.setDoInput(true);
                        conn.setRequestMethod("POST");
                        conn.connect();
                        OutputStream out = conn.getOutputStream();
                        out.write(Long.toString(periodicity).getBytes(StandardCharsets.UTF_8));
                        out.write(32);
                        out.write(39);
                        out.write(URLEncoder.encode("runner.periodicity", StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").getBytes(StandardCharsets.US_ASCII));
                        out.write(39);
                        out.write(32);
                        out.write("STORE".getBytes(StandardCharsets.UTF_8));
                        out.write(10);
                        out.write(39);
                        out.write(URLEncoder.encode(path, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").getBytes(StandardCharsets.US_ASCII));
                        out.write(39);
                        out.write(32);
                        out.write(39);
                        out.write(URLEncoder.encode("runner.path", StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").getBytes(StandardCharsets.US_ASCII));
                        out.write(39);
                        out.write(32);
                        out.write("STORE".getBytes(StandardCharsets.UTF_8));
                        out.write(10);
                        out.write(Long.toString(scheduledat).getBytes(StandardCharsets.UTF_8));
                        out.write(32);
                        out.write(39);
                        out.write(URLEncoder.encode("runner.scheduledat", StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").getBytes(StandardCharsets.US_ASCII));
                        out.write(39);
                        out.write(32);
                        out.write("STORE".getBytes(StandardCharsets.UTF_8));
                        out.write(10);
                        if (null != ScriptRunner.this.runnerPSK) {
                            byte[] now = Longs.toByteArray((long)TimeSource.getTime());
                            byte[] nonce = CryptoHelper.wrapBlob((byte[])ScriptRunner.this.runnerPSK, (byte[])now);
                            out.write(39);
                            out.write(OrderPreservingBase64.encode(nonce));
                            out.write(39);
                            out.write(32);
                            out.write(39);
                            out.write(URLEncoder.encode("runner.nonce", StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").getBytes(StandardCharsets.US_ASCII));
                            out.write(39);
                            out.write(32);
                            out.write("STORE".getBytes(StandardCharsets.UTF_8));
                            out.write(10);
                        }
                        BufferedReader br = new BufferedReader(new InputStreamReader(in));
                        String rawpath = "/" + path.replaceFirst("/" + Long.toString(periodicity) + "/", "/");
                        rawpath = rawpath.substring(0, rawpath.length() - 4);
                        while (null != (line = br.readLine())) {
                            Matcher m = VAR.matcher(line);
                            StringBuffer mc2WithReplacement = new StringBuffer();
                            while (m.find()) {
                                String var = m.group(1);
                                String def = m.group(0);
                                int colonIndex = var.indexOf(58);
                                if (colonIndex >= 0) {
                                    def = var.substring(colonIndex + 1);
                                    var = var.substring(0, colonIndex);
                                }
                                String suffix = rawpath;
                                String value = null;
                                while (suffix.length() > 1 && null == (value = WarpConfig.getProperty(var + "@" + suffix))) {
                                    suffix = suffix.substring(0, suffix.lastIndexOf(47));
                                }
                                if (null == value) {
                                    value = def;
                                }
                                m.appendReplacement(mc2WithReplacement, Matcher.quoteReplacement(value));
                            }
                            m.appendTail(mc2WithReplacement);
                            out.write(mc2WithReplacement.toString().getBytes(StandardCharsets.UTF_8));
                            out.write(10);
                        }
                        br.close();
                        out.write(CLEAR);
                        out.close();
                        if (200 != conn.getResponseCode()) {
                            Sensision.update((String)"warp.script.run.failures", labels, (Long)ttl, (Number)1);
                        }
                    }
                    catch (Exception e) {
                        Sensision.update((String)"warp.script.run.failures", labels, (Long)ttl, (Number)1);
                    }
                    finally {
                        nextrun.put(script, nowts + periodicity);
                        nano = System.nanoTime() - nano;
                        Sensision.update((String)"warp.script.run.time.us", labels, (Long)ttl, (Number)(nano / 1000L));
                        Sensision.update((String)"warp.script.run.current", (Map)Sensision.EMPTY_LABELS, (Number)-1);
                        if (null != conn) {
                            try {
                                conn.disconnect();
                            }
                            catch (Exception exception) {}
                        }
                        if (null != in) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException ree) {
            nextrun.put(script, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributedSchedule(Map<String, Long> nextrun, String script, long periodicity) {
        RunRequest request = new RunRequest();
        String path = new File(script).getAbsolutePath().substring(new File(this.root).getAbsolutePath().length() + 1);
        long now = System.currentTimeMillis();
        request.setScheduledAt(now);
        request.setPeriodicity(periodicity);
        request.setPath(path);
        request.setCompressed(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = null;
        try {
            int len;
            GZIPOutputStream out = new GZIPOutputStream(baos);
            in = new FileInputStream(script);
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
                ((OutputStream)out).close();
            }
        }
        catch (IOException ioe) {
            nextrun.put(script, System.currentTimeMillis());
            return;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException buf) {}
            }
        }
        request.setContent(baos.toByteArray());
        request.setScheduler(this.id);
        byte[] content = null;
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
            content = serializer.serialize((TBase)request);
        }
        catch (TException te) {
            nextrun.put(script, System.currentTimeMillis());
            return;
        }
        if (null != this.KAFKA_AES) {
            content = CryptoUtils.wrap(this.KAFKA_AES, content);
        }
        if (null != this.KAFKA_MAC) {
            content = CryptoUtils.addMAC(this.KAFKA_MAC, content);
        }
        Producer producer = null;
        byte[] key = path.getBytes(StandardCharsets.UTF_8);
        KeyedMessage message = new KeyedMessage(this.topic, (Object)key, (Object)content);
        try {
            producer = this.kafkaProducerPool.getProducer();
            producer.send(message);
        }
        catch (Exception e) {
            nextrun.put(script, System.currentTimeMillis());
            return;
        }
        finally {
            if (null != producer) {
                this.kafkaProducerPool.recycleProducer(producer);
            }
        }
        nextrun.put(script, now + periodicity);
    }

    private Map<String, Long> scanSuperRoot(String superroot) {
        TreeMap<String, Long> scripts = new TreeMap<String, Long>();
        try (DirectoryStream<Path> roots = Files.newDirectoryStream(new File(superroot).toPath());){
            for (Path root : roots) {
                scripts.putAll(this.scanRoot(root.toAbsolutePath().toString()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return scripts;
    }

    public String getRoot() {
        return this.root;
    }

    private Map<String, Long> scanRoot(String root) {
        TreeMap<String, Long> scripts = new TreeMap<String, Long>();
        File dir = new File(root);
        if (!dir.exists()) {
            return scripts;
        }
        try (DirectoryStream<Path> pathes = Files.newDirectoryStream(dir.toPath());){
            for (Path path : pathes) {
                long period;
                File f = path.toFile();
                if (!f.isDirectory() || !f.getParentFile().equals(dir)) continue;
                try {
                    period = Long.valueOf(f.getName());
                    if (period < this.minperiod) {
                    }
                }
                catch (NumberFormatException nfe) {}
                continue;
                try {
                    DirectoryStream<Path> subpathes = Files.newDirectoryStream(f.toPath(), "*.mc2");
                    Throwable throwable = null;
                    try {
                        for (Path subpath : subpathes) {
                            File script = subpath.toFile();
                            scripts.put(script.getAbsolutePath(), period);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (subpathes == null) continue;
                        if (throwable != null) {
                            try {
                                subpathes.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        subpathes.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return scripts;
    }

    public static void main(String[] args) throws Exception {
        ScriptRunner runner = new ScriptRunner(new DummyKeyStore(), System.getProperties());
        runner.start();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void extractKeys(Properties props) {
        byte[] key;
        String keyspec = props.getProperty("runner.kafka.aes");
        if (null != keyspec) {
            key = this.keystore.decodeKey(keyspec);
            Preconditions.checkArgument((16 == key.length || 24 == key.length || 32 == key.length ? 1 : 0) != 0, (Object)"Key runner.kafka.aes MUST be 128, 192 or 256 bits long.");
            this.keystore.setKey("warp.aes.kafka.runner", key);
        }
        if (null != (keyspec = props.getProperty("runner.kafka.mac"))) {
            key = this.keystore.decodeKey(keyspec);
            Preconditions.checkArgument((16 == key.length ? 1 : 0) != 0, (Object)"Key runner.kafka.mac MUST be 128 bits long.");
            this.keystore.setKey("warp.siphash.kafka.runner", key);
        }
        this.keystore.forget();
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);

        NamedThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = null == s ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "[Warp ScriptRunner Thread #" + this.threadNumber.getAndIncrement() + "]", 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (5 != t.getPriority()) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

