/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.continuum.KafkaOffsetCounters;
import io.warp10.continuum.KafkaSynchronizedConsumerPool;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.thrift.data.RunRequest;
import io.warp10.crypto.CryptoUtils;
import io.warp10.script.ScriptRunner;
import io.warp10.sensision.Sensision;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.zip.GZIPInputStream;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ScriptRunnerConsumerFactory
implements KafkaSynchronizedConsumerPool.ConsumerFactory {
    private final ScriptRunner runner;

    public ScriptRunnerConsumerFactory(ScriptRunner runner) {
        this.runner = runner;
    }

    public Runnable getConsumer(final KafkaSynchronizedConsumerPool pool, final KafkaStream<byte[], byte[]> stream) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ConsumerIterator iter = stream.iterator();
                TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
                KafkaOffsetCounters counters = pool.getCounters();
                try {
                    while (iter.hasNext()) {
                        int attempts;
                        boolean nonEmpty = iter.nonEmpty();
                        if (!nonEmpty) continue;
                        MessageAndMetadata msg = iter.next();
                        counters.count(msg.partition(), msg.offset());
                        byte[] data = (byte[])msg.message();
                        Sensision.update((String)"warp.runner.kafka.in.messages", (Map)Sensision.EMPTY_LABELS, (Number)1);
                        Sensision.update((String)"warp.runner.kafka.in.bytes", (Map)Sensision.EMPTY_LABELS, (Number)data.length);
                        if (null != ((ScriptRunnerConsumerFactory)ScriptRunnerConsumerFactory.this).runner.KAFKA_MAC) {
                            data = CryptoUtils.removeMAC(((ScriptRunnerConsumerFactory)ScriptRunnerConsumerFactory.this).runner.KAFKA_MAC, data);
                        }
                        if (null == data) {
                            Sensision.update((String)"warp.runner.kafka.in.invalidmacs", (Map)Sensision.EMPTY_LABELS, (Number)1);
                            continue;
                        }
                        if (null != ((ScriptRunnerConsumerFactory)ScriptRunnerConsumerFactory.this).runner.KAFKA_AES) {
                            data = CryptoUtils.unwrap(((ScriptRunnerConsumerFactory)ScriptRunnerConsumerFactory.this).runner.KAFKA_AES, data);
                        }
                        if (null == data) {
                            Sensision.update((String)"warp.runner.kafka.in.invalidciphers", (Map)Sensision.EMPTY_LABELS, (Number)1);
                            continue;
                        }
                        final RunRequest request = new RunRequest();
                        deserializer.deserialize((TBase)request, data);
                        long now = System.currentTimeMillis();
                        if (request.getScheduledAt() + request.getPeriodicity() >= now) continue;
                        if (request.isCompressed()) {
                            int len;
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(request.getContent()));
                            byte[] buf = new byte[8192];
                            while ((len = in.read(buf)) > 0) {
                                out.write(buf, 0, len);
                            }
                            in.close();
                            out.close();
                            request.setContent(out.toByteArray());
                        }
                        for (attempts = 3; attempts > 0; --attempts) {
                            try {
                                ((ScriptRunnerConsumerFactory)ScriptRunnerConsumerFactory.this).runner.executor.submit(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        Sensision.update((String)"warp.script.run.current", (Map)Sensision.EMPTY_LABELS, (Number)1);
                                        HashMap<String, String> labels = new HashMap<String, String>();
                                        labels.put("path", request.getPath());
                                        Sensision.update((String)"warp.script.run.count", labels, (Number)1);
                                        long nano = System.nanoTime();
                                        HttpURLConnection conn = null;
                                        long ops = 0L;
                                        long fetched = 0L;
                                        long elapsed = 0L;
                                        try {
                                            String header;
                                            conn = (HttpURLConnection)new URL(((ScriptRunnerConsumerFactory)ScriptRunnerConsumerFactory.this).runner.endpoint).openConnection();
                                            conn.setDoOutput(true);
                                            conn.setChunkedStreamingMode(8192);
                                            conn.setDoInput(true);
                                            conn.setRequestMethod("POST");
                                            conn.connect();
                                            OutputStream out = conn.getOutputStream();
                                            out.write(Long.toString(request.getPeriodicity()).getBytes(StandardCharsets.UTF_8));
                                            out.write(32);
                                            out.write(39);
                                            out.write(URLEncoder.encode("runner.periodicity", StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").getBytes(StandardCharsets.US_ASCII));
                                            out.write(39);
                                            out.write(32);
                                            out.write("STORE".getBytes(StandardCharsets.UTF_8));
                                            out.write(10);
                                            out.write(39);
                                            out.write(URLEncoder.encode(request.getPath(), StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").getBytes(StandardCharsets.US_ASCII));
                                            out.write(39);
                                            out.write(32);
                                            out.write(39);
                                            out.write(URLEncoder.encode("runner.path", StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").getBytes(StandardCharsets.US_ASCII));
                                            out.write(39);
                                            out.write(32);
                                            out.write("STORE".getBytes(StandardCharsets.UTF_8));
                                            out.write(10);
                                            out.write(Long.toString(request.getScheduledAt()).getBytes(StandardCharsets.UTF_8));
                                            out.write(32);
                                            out.write(39);
                                            out.write(URLEncoder.encode("runner.scheduledat", StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").getBytes(StandardCharsets.US_ASCII));
                                            out.write(39);
                                            out.write(32);
                                            out.write("STORE".getBytes(StandardCharsets.UTF_8));
                                            out.write(10);
                                            byte[] data = request.getContent();
                                            if (request.isCompressed()) {
                                                int len;
                                                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                                                GZIPInputStream gzis = new GZIPInputStream(bais);
                                                byte[] buf = new byte[1024];
                                                while ((len = bais.read(buf)) >= 0) {
                                                    out.write(buf, 0, len);
                                                }
                                                gzis.close();
                                            } else {
                                                out.write(data, 0, data.length);
                                            }
                                            ScriptRunnerConsumerFactory.this.runner;
                                            out.write(ScriptRunner.CLEAR);
                                            out.close();
                                            if (200 != conn.getResponseCode()) {
                                                Sensision.update((String)"warp.script.run.failures", labels, (Number)1);
                                            }
                                            if (null != (header = conn.getRequestProperty(Constants.getHeader("http.header.elapsed")))) {
                                                try {
                                                    elapsed = Long.parseLong(header);
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                            if (null != (header = conn.getRequestProperty(Constants.getHeader("http.header.ops")))) {
                                                try {
                                                    ops = Long.parseLong(header);
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                            if (null != (header = conn.getRequestProperty(Constants.getHeader("http.header.fetched")))) {
                                                try {
                                                    fetched = Long.parseLong(header);
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            Sensision.update((String)"warp.script.run.failures", labels, (Number)1);
                                        }
                                        finally {
                                            nano = System.nanoTime() - nano;
                                            Sensision.update((String)"warp.script.run.time.us", labels, (Number)(nano / 1000L));
                                            Sensision.update((String)"warp.script.run.elapsed.ns", labels, (Number)elapsed);
                                            Sensision.update((String)"warp.script.run.fetched", labels, (Number)fetched);
                                            Sensision.update((String)"warp.script.run.ops", labels, (Number)ops);
                                            Sensision.update((String)"warp.script.run.current", (Map)Sensision.EMPTY_LABELS, (Number)-1);
                                            if (null != conn) {
                                                conn.disconnect();
                                            }
                                        }
                                    }
                                });
                                break;
                            }
                            catch (RejectedExecutionException ree) {
                                Sensision.update((String)"warp.runner.rejections", (Map)Sensision.EMPTY_LABELS, (Number)1);
                                continue;
                            }
                        }
                        if (0 != attempts) continue;
                        Sensision.update((String)"warp.runner.failures", (Map)Sensision.EMPTY_LABELS, (Number)1);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
                finally {
                    pool.getAbort().set(true);
                }
            }
        };
    }
}

