/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.functions.INCLUDE;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.file.FileURLConnection;

public class WarpScriptMacroLibrary {
    private static final Map<String, WarpScriptStack.Macro> macros = new HashMap<String, WarpScriptStack.Macro>();

    public static void addJar(String path) throws WarpScriptException {
        WarpScriptMacroLibrary.addJar(path, null);
    }

    private static void addJar(String path, String resource) throws WarpScriptException {
        File f = new File(path);
        if (!f.exists() || !f.isFile()) {
            throw new WarpScriptException("File not found " + f.getAbsolutePath());
        }
        JarFile jar = null;
        try {
            String basename = f.getName();
            jar = new JarFile(f);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".mc2") || null != resource && !resource.equals(name)) continue;
                name = name.substring(0, name.length() - ".mc2".length());
                InputStream in = jar.getInputStream(entry);
                WarpScriptStack.Macro macro = WarpScriptMacroLibrary.loadMacro(jar, in, name);
                macro.setSecure(true);
                macros.put(name, macro);
            }
        }
        catch (IOException ioe) {
            throw new WarpScriptException("Encountered error while loading " + f.getAbsolutePath(), ioe);
        }
        finally {
            if (null != jar) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static WarpScriptStack.Macro loadMacro(Object root, InputStream in, String name) throws WarpScriptException {
        try {
            int len;
            byte[] buf = new byte[8192];
            StringBuilder sb = new StringBuilder();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            in.close();
            byte[] data = out.toByteArray();
            sb.setLength(0);
            sb.append(" ");
            sb.append(new String(data, StandardCharsets.UTF_8));
            sb.append("\n");
            MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null, new Properties());
            stack.maxLimits();
            stack.setAttribute("macro.name", name);
            AtomicBoolean enabled = new AtomicBoolean(true);
            final INCLUDE include = root instanceof File ? new INCLUDE("INCLUDE", (File)root, enabled) : new INCLUDE("INCLUDE", (JarFile)root, enabled);
            stack.define("INCLUDE", new WarpScriptStack.Macro(){

                @Override
                public boolean isSecure() {
                    return true;
                }

                @Override
                public List<Object> statements() {
                    return new ArrayList<Object>(){
                        {
                            this.add(include);
                        }
                    };
                }
            });
            stack.execMulti(sb.toString());
            enabled.set(false);
            if (1 != stack.depth()) {
                throw new WarpScriptException("Stack depth was not 1 after the code execution.");
            }
            if (!(stack.peek() instanceof WarpScriptStack.Macro)) {
                throw new WarpScriptException("No macro was found on top of the stack.");
            }
            WarpScriptStack.Macro macro = (WarpScriptStack.Macro)stack.pop();
            macro.setSecure(true);
            macro.setNameRecursive(name);
            WarpScriptStack.Macro macro2 = macro;
            return macro2;
        }
        catch (IOException ioe) {
            throw new WarpScriptException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static WarpScriptStack.Macro find(String name) throws WarpScriptException {
        if (name.contains("/../") || name.contains("/./") || name.startsWith("../") || name.startsWith("./") || name.startsWith("/")) {
            return null;
        }
        WarpScriptStack.Macro macro = macros.get(name);
        if (null == macro) {
            String rsc = name + ".mc2";
            URL url = WarpScriptMacroLibrary.class.getClassLoader().getResource(rsc);
            if (null != url) {
                try {
                    URLConnection conn = url.openConnection();
                    if (conn instanceof JarURLConnection) {
                        JarURLConnection connection = (JarURLConnection)url.openConnection();
                        URL fileurl = connection.getJarFileURL();
                        File f = new File(fileurl.toURI());
                        WarpScriptMacroLibrary.addJar(f.getAbsolutePath(), rsc);
                        macro = macros.get(name);
                    } else if (conn instanceof FileURLConnection) {
                        String urlstr = url.toString();
                        File root = new File(urlstr.substring(0, urlstr.length() - name.length() - ".mc2".length()));
                        macro = WarpScriptMacroLibrary.loadMacro(root, conn.getInputStream(), name);
                    }
                }
                catch (URISyntaxException use) {
                    throw new WarpScriptException("Error while loading '" + name + "'", use);
                }
                catch (IOException ioe) {
                    throw new WarpScriptException("Error while loading '" + name + "'", ioe);
                }
            }
        }
        return macro;
    }
}

