/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;

public class Mean
extends NamedWarpScriptFunction
implements WarpScriptAggregatorFunction,
WarpScriptMapperFunction,
WarpScriptBucketizerFunction,
WarpScriptReducerFunction {
    private final boolean ignoreNulls;

    public Mean(String name, boolean ignoreNulls) {
        super(name);
        this.ignoreNulls = ignoreNulls;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        GeoTimeSerie.TYPE sumType = GeoTimeSerie.TYPE.UNDEFINED;
        long suml = 0L;
        double sumd = 0.0;
        long ticksum = 0L;
        long latitudes = 0L;
        long longitudes = 0L;
        int locationcount = 0;
        long elev = 0L;
        int elevationcount = 0;
        int nulls = 0;
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (null == value) {
                ++nulls;
                continue;
            }
            ticksum += ticks[i] - ticks[0];
            if (91480763316633925L != locations[i]) {
                long[] xy = GeoXPLib.xyFromGeoXPPoint((long)locations[i]);
                latitudes += xy[0];
                longitudes += xy[1];
                ++locationcount;
            }
            if (Long.MIN_VALUE != elevations[i]) {
                elev += elevations[i];
                ++elevationcount;
            }
            if (GeoTimeSerie.TYPE.LONG == sumType) {
                suml += ((Number)value).longValue();
                continue;
            }
            if (GeoTimeSerie.TYPE.DOUBLE == sumType) {
                sumd += ((Number)value).doubleValue();
                continue;
            }
            if (value instanceof Long) {
                sumType = GeoTimeSerie.TYPE.LONG;
                suml = ((Number)value).longValue();
                continue;
            }
            if (value instanceof Double) {
                sumType = GeoTimeSerie.TYPE.DOUBLE;
                sumd = ((Number)value).doubleValue();
                continue;
            }
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        long meanlocation = 91480763316633925L;
        long meanelevation = Long.MIN_VALUE;
        if (locationcount > 0) {
            meanlocation = GeoXPLib.toGeoXPPoint((long)(latitudes /= (long)locationcount), (long)(longitudes /= (long)locationcount));
        }
        if (elevationcount > 0) {
            meanelevation = elev / (long)elevationcount;
        }
        Double meanvalue = null;
        if (!this.ignoreNulls && nulls > 0) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        if (GeoTimeSerie.TYPE.LONG == sumType) {
            meanvalue = (double)suml / (double)(values.length - nulls);
        } else if (GeoTimeSerie.TYPE.DOUBLE == sumType) {
            meanvalue = sumd / (double)(values.length - nulls);
        }
        return new Object[]{ticks[0] + ticksum / (long)ticks.length, meanlocation, meanelevation, meanvalue};
    }
}

