/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.sharding;

import io.warp10.WarpConfig;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.JSONTO;
import io.warp10.script.functions.SNAPSHOT;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.zip.GZIPInputStream;

public class DEVAL
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final ExecutorService executor;
    private static final int maxThreadsPerRequest;
    private static Map<URL, Set<Long>> endpoints;
    private static long shardmodulus;
    private static byte[] snapshot;
    private static JSONTO JSONTO;

    public DEVAL(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a Macro.");
        }
        StringBuilder sb = new StringBuilder();
        SNAPSHOT.addElement(sb, top);
        sb.append(" ");
        sb.append("EVAL");
        final String params = sb.toString();
        final AtomicInteger pending = new AtomicInteger(0);
        final AtomicBoolean aborted = new AtomicBoolean(false);
        ArrayList<URL> urls = new ArrayList<URL>(endpoints.keySet());
        Collections.shuffle(urls);
        HashSet remainders = new HashSet();
        ArrayList<URL> finalurls = new ArrayList<URL>();
        for (URL url : urls) {
            if (remainders.containsAll((Collection)endpoints.get(url))) continue;
            remainders.addAll(endpoints.get(url));
            finalurls.add(url);
            if (shardmodulus != (long)remainders.size()) continue;
            break;
        }
        Future[] futures = new Future[finalurls.size()];
        int i = 0;
        while (i < futures.length) {
            while (!aborted.get() && pending.get() >= maxThreadsPerRequest) {
                LockSupport.parkNanos(1000000L);
            }
            if (aborted.get()) break;
            try {
                final URL endpoint = (URL)finalurls.get(i);
                futures[i] = executor.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        if (aborted.get()) {
                            throw new WarpScriptException("Execution aborted.");
                        }
                        HttpURLConnection conn = null;
                        try {
                            String result;
                            int len;
                            OutputStream connout;
                            conn = (HttpURLConnection)endpoint.openConnection();
                            conn.setChunkedStreamingMode(8192);
                            conn.setRequestProperty("Accept-Encoding", "gzip");
                            conn.setDoInput(true);
                            conn.setDoOutput(true);
                            conn.setRequestMethod("POST");
                            OutputStream out = connout = conn.getOutputStream();
                            out.write(params.getBytes(StandardCharsets.UTF_8));
                            out.write(10);
                            out.write(snapshot);
                            out.write(10);
                            connout.flush();
                            InputStream in = conn.getInputStream();
                            if ("gzip".equals(conn.getContentEncoding())) {
                                in = new GZIPInputStream(in);
                            }
                            if (200 != conn.getResponseCode()) {
                                throw new WarpScriptException(DEVAL.this.getName() + " remote execution encountered an error: " + conn.getHeaderField(Constants.getHeader("X-Warp10-Error-Message")));
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            byte[] buf = new byte[1024];
                            while ((len = in.read(buf)) >= 0) {
                                baos.write(buf, 0, len);
                            }
                            byte[] bytes = baos.toByteArray();
                            String string = result = new String(bytes, StandardCharsets.UTF_8);
                            return string;
                        }
                        catch (IOException ioe) {
                            aborted.set(true);
                            if (null != conn) {
                                throw new IOException(conn.getResponseMessage());
                            }
                            throw ioe;
                        }
                        finally {
                            if (null != conn) {
                                conn.disconnect();
                            }
                            pending.addAndGet(-1);
                        }
                    }
                });
                pending.addAndGet(1);
            }
            catch (RejectedExecutionException ree) {
                continue;
            }
            ++i;
        }
        while (!aborted.get() && pending.get() > 0) {
            LockSupport.parkNanos(1000000L);
        }
        if (aborted.get()) {
            for (i = 0; i < futures.length; ++i) {
                if (null == futures[i]) continue;
                try {
                    futures[i].get();
                    continue;
                }
                catch (ExecutionException ee) {
                    throw new WarpScriptException(this.getName() + " execution was aborted.", ee);
                }
                catch (InterruptedException ie) {
                    throw new WarpScriptException(this.getName() + " execution was interrupted.", ie);
                }
            }
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (i = 0; i < futures.length; ++i) {
            try {
                String result = (String)futures[i].get();
                stack.push(result);
                JSONTO.apply(stack);
                results.add(stack.pop());
                continue;
            }
            catch (ExecutionException ee) {
                throw new WarpScriptException(ee.getCause());
            }
            catch (WarpScriptException wse) {
                throw wse;
            }
            catch (Exception e) {
                throw new WarpScriptException(e);
            }
        }
        stack.push(results);
        return stack;
    }

    static {
        endpoints = new HashMap<URL, Set<Long>>();
        snapshot = WarpConfig.getProperty("sharding.snapshot", "SNAPSHOT").trim().getBytes(StandardCharsets.UTF_8);
        int poolsize = Integer.parseInt(WarpConfig.getProperty("sharding.poolsize", "4"));
        maxThreadsPerRequest = Integer.parseInt(WarpConfig.getProperty("sharding.maxthreadspercall", Integer.toString(poolsize)));
        LinkedBlockingDeque<Runnable> queue = new LinkedBlockingDeque<Runnable>(poolsize * 2);
        executor = new ThreadPoolExecutor(poolsize, poolsize, 60L, TimeUnit.SECONDS, queue);
        long shardmodulus = -1L;
        Properties props = WarpConfig.getProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (!entry.getKey().toString().startsWith("sharding.endpoint.")) continue;
            String spec = entry.getKey().toString().substring("sharding.endpoint.".length());
            String[] tokens = (spec = spec.replaceAll(".*\\.", "")).split(":");
            if (2 != tokens.length) continue;
            long modulus = Long.parseLong(tokens[0].trim());
            long remainder = Long.parseLong(tokens[1].trim());
            if (modulus <= 0L || remainder < 0L || remainder >= modulus) continue;
            if (-1L == shardmodulus) {
                shardmodulus = modulus;
            }
            if (modulus != shardmodulus) {
                throw new RuntimeException("Invalid modulus " + modulus + " for shard '" + entry.getKey() + "', should be " + shardmodulus);
            }
            try {
                URL url = new URL(entry.getValue().toString().trim());
                Set<Long> remainders = endpoints.get(url);
                if (null == remainders) {
                    remainders = new HashSet<Long>();
                    endpoints.put(url, remainders);
                }
                remainders.add(remainder);
            }
            catch (MalformedURLException mue) {
                throw new RuntimeException(mue);
            }
        }
        HashSet<Long> allremainders = new HashSet<Long>();
        for (Set<Long> rems : endpoints.values()) {
            allremainders.addAll(rems);
        }
        if (shardmodulus != (long)allremainders.size()) {
            throw new RuntimeException("Missing shards, only have " + allremainders.size() + " shards defined out of " + shardmodulus);
        }
        JSONTO = new JSONTO("JSON->");
    }
}

