/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.token;

import io.warp10.continuum.Tokens;
import io.warp10.crypto.KeyStore;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.crypto.SipHashInline;
import io.warp10.quasar.encoder.QuasarTokenDecoder;
import io.warp10.quasar.encoder.QuasarTokenEncoder;
import io.warp10.quasar.filter.exception.QuasarTokenException;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.quasar.token.thrift.data.TokenType;
import io.warp10.quasar.token.thrift.data.WriteToken;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.ext.token.TokenWarpScriptExtension;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;

public class TOKENDUMP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final QuasarTokenEncoder encoder = new QuasarTokenEncoder();
    private final QuasarTokenDecoder decoder;
    public static final String KEY_PARAMS = "params";
    private byte[] tokenAESKey = null;
    private byte[] tokenSipHashKey = null;

    public TOKENDUMP(String name) {
        super(name);
        this.decoder = null;
    }

    public TOKENDUMP(String name, KeyStore keystore) {
        super(name);
        this.tokenAESKey = keystore.getKey("warp.aes.token");
        this.tokenSipHashKey = keystore.getKey("warp.siphash.token");
        long[] lkey = SipHashInline.getKey(this.tokenSipHashKey);
        this.decoder = new QuasarTokenDecoder(lkey[0], lkey[1], this.tokenAESKey);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        if (null == this.tokenAESKey || null == this.tokenSipHashKey) {
            throw new WarpScriptException(this.getName() + " cannot be used in this context.");
        }
        Object top = stack.pop();
        String secret = TokenWarpScriptExtension.TOKEN_SECRET;
        if (null != secret) {
            if (!(top instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a token secret on top of the stack.");
            }
            if (!secret.equals(top)) {
                throw new WarpScriptException(this.getName() + " invalid token secret.");
            }
            top = stack.pop();
        }
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a token on top of the stack.");
        }
        String tokenstr = top.toString();
        ReadToken rtoken = null;
        WriteToken wtoken = null;
        byte[] token = OrderPreservingBase64.decode(tokenstr.getBytes(StandardCharsets.UTF_8));
        try {
            rtoken = this.decoder.decodeReadToken(token);
        }
        catch (QuasarTokenException qte) {
            try {
                wtoken = this.decoder.decodeWriteToken(token);
            }
            catch (Exception e) {
                throw new WarpScriptException(this.getName() + " invalid token.", e);
            }
        }
        String ident = this.encoder.getTokenIdent(tokenstr, this.tokenSipHashKey);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("token", tokenstr);
        result.put("ident", ident);
        result.put(KEY_PARAMS, this.mapFromToken((TBase)(null != rtoken ? rtoken : wtoken)));
        stack.push(result);
        return stack;
    }

    public Map<String, Object> mapFromToken(TBase token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (token instanceof ReadToken) {
            ReadToken rtoken = (ReadToken)token;
            params.put("type", TokenType.READ.toString());
            params.put("owner", Tokens.getUUID(rtoken.getBilledId()));
            params.put("application", rtoken.getAppName());
            params.put("issuance", rtoken.getIssuanceTimestamp());
            params.put("expiry", rtoken.getExpiryTimestamp());
            if (rtoken.getOwnersSize() > 0) {
                ArrayList<String> owners = new ArrayList<String>();
                params.put("owners", owners);
                for (ByteBuffer bb : rtoken.getOwners()) {
                    owners.add(Tokens.getUUID(bb));
                }
            }
            if (rtoken.getProducersSize() > 0) {
                ArrayList<String> producers = new ArrayList<String>();
                params.put("producers", producers);
                for (ByteBuffer bb : rtoken.getProducers()) {
                    producers.add(Tokens.getUUID(bb));
                }
            }
            if (rtoken.getAppsSize() > 0) {
                ArrayList<String> applications = new ArrayList<String>();
                params.put("applications", applications);
                for (String app : rtoken.getApps()) {
                    applications.add(app);
                }
            }
            if (rtoken.getAttributesSize() > 0) {
                HashMap<String, String> attr = new HashMap<String, String>(rtoken.getAttributes());
                params.put("attributes", attr);
            }
            if (rtoken.getLabelsSize() > 0) {
                HashMap<String, String> labels = new HashMap<String, String>(rtoken.getLabels());
                params.put("labels", labels);
            }
        } else {
            WriteToken wtoken = (WriteToken)token;
            params.put("type", TokenType.WRITE.toString());
            params.put("owner", Tokens.getUUID(wtoken.getOwnerId()));
            params.put("producer", Tokens.getUUID(wtoken.getProducerId()));
            params.put("application", wtoken.getAppName());
            params.put("issuance", wtoken.getIssuanceTimestamp());
            params.put("expiry", wtoken.getExpiryTimestamp());
            if (wtoken.getAttributesSize() > 0) {
                HashMap<String, String> attr = new HashMap<String, String>(wtoken.getAttributes());
                params.put("attributes", attr);
            }
            if (wtoken.getLabelsSize() > 0) {
                HashMap<String, String> labels = new HashMap<String, String>(wtoken.getLabels());
                params.put("labels", labels);
            }
        }
        return params;
    }
}

